% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annoHighlight.R
\name{annoHighlight}
\alias{annoHighlight}
\title{Annotates a highlight box around a specified genomic region of a
plot}
\usage{
annoHighlight(
    plot,
    chrom,
    chromstart = NULL,
    chromend = NULL,
    fill = "grey",
    linecolor = NA,
    alpha = 0.4,
    y,
    height,
    just = c("left", "top"),
    default.units = "inches",
    params = NULL,
    ...
)
}
\arguments{
\item{plot}{Input plot on which to annotate genomic region.}

\item{chrom}{Chromosome of region to be highlighted, as a string.}

\item{chromstart}{Integer start position on chromosome to be highlighted.}

\item{chromend}{Integer end position on chromosome to be highlighted.}

\item{fill}{A character value specifying highlight box fill color.
Default value is \code{fill = "grey"}.}

\item{linecolor}{A character value specifying highlight box line color.
Default value is \code{linecolor = NA}.}

\item{alpha}{Numeric value specifying color transparency.
Default value is \code{alpha = 0.4}.}

\item{y}{A numeric, unit object, or character containing a "b" combined
with a numeric value specifying square highlight box y-location.
The character value will place the highlight box y relative to the
bottom of the most recently plotted plot according to the
units of the \code{plotgardener} page.}

\item{height}{A numeric or unit object specifying highlight box height.}

\item{just}{Justification of highlight box relative to its (x, y)
location. If there are two values, the first value specifies horizontal
justification and the second value specifies vertical justification.
Possible string values are: \code{"left"}, \code{"right"},
\code{"centre"}, \code{"center"}, \code{"bottom"}, and \code{"top"}.
Default value is \code{just = c("left", "top")}.}

\item{default.units}{A string indicating the default units to use if
\code{y} or \code{height} are only given as numerics or numeric vectors.
Default value is \code{default.units = "inches"}.}

\item{params}{An optional \link[plotgardener]{pgParams} object containing
relevant function parameters.}

\item{...}{Additional grid graphical parameters. See \link[grid]{gpar}.}
}
\value{
Returns a \code{highlight} object containing relevant
genomic region, placement, and \link[grid]{grob} information.
}
\description{
Annotates a highlight box around a specified genomic region of a
plot
}
\examples{
## Create a page
pageCreate(width = 7.5, height = 1.5, default.units = "inches")

## Plot and place a signal plot
library(plotgardenerData)
data("IMR90_ChIP_H3K27ac_signal")
region <- pgParams(
    chrom = "chr21",
    chromstart = 28000000, chromend = 30300000,
    assembly = "hg19",
    range = c(0, 45)
)
signalPlot <- plotSignal(
    data = IMR90_ChIP_H3K27ac_signal, params = region,
    x = 0.5, y = 0.25, width = 6.5, height = 0.65,
    just = c("left", "top"),
    default.units = "inches"
)

## Highlight genomic region on signal plot
annoHighlight(
    plot = signalPlot,
    chrom = "chr21",
    chromstart = 29000000, chromend = 29125000,
    y = 0.25, height = 1, just = c("left", "top"),
    default.units = "inches"
)

## Plot text label
plotText(
    label = "region of interest", fontsize = 8, fontcolor = "black",
    x = 3.5, y = 0.2, just = "bottom", default.units = "inches"
)

## Plot genome label
plotGenomeLabel(
    chrom = "chr21",
    chromstart = 28000000, chromend = 30300000,
    assembly = "hg19",
    x = 0.5, y = 1.3, length = 6.5, default.units = "inches"
)

## Hide page guides
pageGuideHide()
}
