% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annoHeatmapLegend.R
\name{annoHeatmapLegend}
\alias{annoHeatmapLegend}
\title{Add a color scale legend for heatmap-style plots}
\usage{
annoHeatmapLegend(
    plot,
    orientation = "v",
    fontsize = 8,
    fontcolor = "dark grey",
    scientific = FALSE,
    digits = 1,
    ticks = FALSE,
    breaks = NULL,
    border = FALSE,
    x,
    y,
    width,
    height,
    just = c("left", "top"),
    default.units = "inches",
    params = NULL,
    ...
)
}
\arguments{
\item{plot}{Heatmap-style plot object to add heatmap legend for.}

\item{orientation}{A string specifying legend orientation.
Default value is \code{orientation = "v"}. Options are:
\itemize{
\item{\code{"v"}: }{Vertical legend orientation.}
\item{\code{"h"}: }{Horizontal legend orientation.}
}}

\item{fontsize}{A numeric specifying text fontsize in points.
Default value is \code{fontsize = 8}.}

\item{fontcolor}{Character value specfying text fontcolor.
Default value is \code{fontcolor = "dark grey"}.}

\item{scientific}{Logical value specifying if numeric color value labels
should be encoded in scientific format.
Default value is \code{scientific = FALSE}.}

\item{digits}{Numeric specifying how many significant digits to include
of numeric color value labels. Default value is \code{digits = 1}.}

\item{ticks}{Logical value specifying if tick marks on the heatmap
colorbar should be visible. Default value is \code{ticks = FALSE}.}

\item{breaks}{A numeric vector specifying tick breaks.
Default value is \code{breaks = NULL}.}

\item{border}{Logical value indicating whether to add a border around
heatmap legend. Default value is \code{border = FALSE}.}

\item{x}{A numeric or unit object specifying x-location of legend.}

\item{y}{A numeric, unit object, or character containing a "b" combined
with a numeric value specifying y-location of legend.
The character value will place the legend y relative to the bottom of the
most recently plotted plot according to the units of
the plotgardener page.}

\item{width}{A numeric or unit object specifying width of legend.}

\item{height}{A numeric or unit object specifying height of legend.}

\item{just}{Justification of heatmap legend relative to
its (x, y) location. If there are two values, the first value specifies
horizontal justification and the second value specifies vertical
justification. Possible string values are: \code{"left"}, \code{"right"},
\code{"centre"}, \code{"center"}, \code{"bottom"}, and \code{"top"}.
Default value is \code{just = c("left", "top")}.}

\item{default.units}{A string indicating the default units to use if
\code{x}, \code{y}, \code{width}, or \code{height} are only given as
numerics. Default value is \code{default.units = "inches"}.}

\item{params}{An optional \link[plotgardener]{pgParams} object containing
relevant function parameters.}

\item{...}{Additional grid graphical parameters. See \link[grid]{gpar}.}
}
\value{
Returns a \code{heatmapLegend} object with relevant
color value, placement, and \link[grid]{grob} information.
}
\description{
Add a color scale legend for heatmap-style plots
}
\examples{
## Load Hi-C data
library(plotgardenerData)
data("IMR90_HiC_10kb")

## Create page
pageCreate(width = 4, height = 3.5, default.units = "inches")

## Plot and place a square Hi-C plot
hicPlot <- plotHicSquare(
    data = IMR90_HiC_10kb, resolution = 10000,
    zrange = c(0, 70),
    chrom = "chr21",
    chromstart = 28000000, chromend = 30300000,
    assembly = "hg19",
    x = 0.5, y = 0.5, width = 2.5, height = 2.5,
    just = c("left", "top"),
    default.units = "inches"
)

## Add heatmap legend
annoHeatmapLegend(
    plot = hicPlot,
    x = 3.2, y = 0.5, width = 0.12, height = 1.2,
    just = c("left", "top"), default.units = "inches"
)

## Annotate genome label
annoGenomeLabel(
    plot = hicPlot, x = 0.5, y = 3.03, scale = "Mb",
    just = c("left", "top")
)

## Hide page guides
pageGuideHide()
}
