% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/inspecting.R
\name{inspecting}
\alias{inspecting}
\alias{inspecting,MultiAssayExperiment-method}
\alias{inspecting,SummarizedExperiment-method}
\alias{inspecting,MultiDataSet-method}
\alias{inspecting,ExpressionSet-method}
\title{Inspecting}
\usage{
inspecting(
  x,
  pool_as_pool1.l = FALSE,
  pool_cv.n = 0.3,
  loess_span.n = 1,
  sample_intensity.c = c("median", "mean", "sum")[2],
  title.c = NA,
  plot_dims.l = TRUE,
  figure.c = c("none", "interactive", "myfile.pdf")[2],
  report.c = c("none", "interactive", "myfile.txt")[2]
)

\S4method{inspecting}{MultiAssayExperiment}(
  x,
  pool_as_pool1.l = FALSE,
  pool_cv.n = 0.3,
  loess_span.n = 1,
  sample_intensity.c = c("median", "mean", "sum")[2],
  title.c = NA,
  plot_dims.l = TRUE,
  figure.c = c("none", "interactive", "myfile.pdf")[2],
  report.c = c("none", "interactive", "myfile.txt")[2]
)

\S4method{inspecting}{SummarizedExperiment}(
  x,
  pool_as_pool1.l = FALSE,
  pool_cv.n = 0.3,
  loess_span.n = 1,
  sample_intensity.c = c("median", "mean", "sum")[2],
  title.c = NA,
  plot_dims.l = TRUE,
  figure.c = c("none", "interactive", "myfile.pdf")[2],
  report.c = c("none", "interactive", "myfile.txt")[2]
)

\S4method{inspecting}{MultiDataSet}(
  x,
  pool_as_pool1.l = FALSE,
  pool_cv.n = 0.3,
  loess_span.n = 1,
  sample_intensity.c = c("median", "mean", "sum")[2],
  title.c = NA,
  plot_dims.l = TRUE,
  figure.c = c("none", "interactive", "myfile.pdf")[2],
  report.c = c("none", "interactive", "myfile.txt")[2]
)

\S4method{inspecting}{ExpressionSet}(
  x,
  pool_as_pool1.l = FALSE,
  pool_cv.n = 0.3,
  loess_span.n = 1,
  sample_intensity.c = c("median", "mean", "sum")[2],
  title.c = NA,
  plot_dims.l = TRUE,
  figure.c = c("none", "interactive", "myfile.pdf")[2],
  report.c = c("none", "interactive", "myfile.txt")[2]
)
}
\arguments{
\item{x}{An S4 object of class \code{SummarizedExperiment}
or \code{MultiAssayExperiment} (\code{ExpressionSet} and \code{MultiDataSet}
are still supported)}

\item{pool_as_pool1.l}{logical(1): should pool be included (as pool1)
in the correlation with the dilution factor? [default = FALSE]}

\item{pool_cv.n}{numeric(1): threshold for the coefficient of variation
of the pools; the default value (30\%) is often used in metabolomics}

\item{loess_span.n}{numeric(1): span parameter used in the loess trend
estimation; the default value is set to 1 to prevent overfitting}

\item{sample_intensity.c}{Character: function to be used to display the
global sample intensity; default: 'mean'}

\item{title.c}{character(1): MultiAssayExperiment: title of the barplot
showing the number of samples and variables in each dataset; ExpressionSet:
title of the multipanel graphic displaying the metrics (if NA -default- the
title slot from the experimentData will be used)}

\item{plot_dims.l}{(MultiAssayExperiment) logical(1): should an overview of
the number of samples and variables in all datasets be barplotted?}

\item{figure.c}{character(1): File name with '.pdf' extension for the figure;
if 'interactive' (default), figures will be displayed interactively;
if 'none', no figure will be generated}

\item{report.c}{character(1): File name with '.txt' extension for the printed
results (call to sink()'); if 'interactive' (default), messages will be
printed on the screen; if 'none', no verbose will be generated}
}
\value{
\code{SummarizedExperiment} or \code{MultiAssayExperiment}
(or \code{ExpressionSet} and \code{MultiDataSet}) including the computed
sample and variable metrics in the rowData and colData metadata.
}
\description{
Provides numerical metrics and graphical overview of SummarizedExperiment,
MultiAssayExperiment, ExpressionSet, or MultiDataSet instance
}
\examples{
sacurine.se <- reading(system.file("extdata/sacurine", package = "phenomis"))
sacurine.se <- inspecting(sacurine.se)
sacurine.se <- correcting(sacurine.se)
sacurine.se <- inspecting(sacurine.se)
sacurine.se <- transforming(sacurine.se)
sacurine.se <- inspecting(sacurine.se)

# MultiAssayExperiment
prometis.mae <- reading(system.file("extdata/prometis",
                                    package = "phenomis"))
prometis.mae <- inspecting(prometis.mae)
}
