% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/limmaAnalysis.R
\name{limmaAnalysis}
\alias{limmaAnalysis}
\title{Differential Expression analysis.}
\usage{
limmaAnalysis(
  es,
  fieldValues,
  version = "One-factor design",
  contrast = list("Comparison", "Target", "Reference"),
  designData = NULL
)
}
\arguments{
\item{es}{ExpressionSet object. It should be normalized for
more accurate analysis.}

\item{fieldValues}{Vector of comparison values, mapping
categories' names to columns/samples}

\item{version}{name of the limma analysis implementation. Should be "One-factor design" or "Advanced design"}

\item{contrast}{a character vector with exactly three elements: the name of a factor in the design formula, the name of the numerator level for the fold change, and the name of the denominator level for the fold change}

\item{designData}{data.frame with design matrix}
}
\value{
Name of the file containing serialized de-matrix.
}
\description{
\code{limmaAnalysis} performs differential expression analysis
    from limma package and returns a ProtoBuf-serialized resulting
    de-matrix.
}
\examples{
\dontrun{
data(es)
limmaAnalysis(es, fieldValues = c("A", "A", "A", "B", "B"))
}
}
\keyword{internal}
