% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgxLoader.R
\name{pgxLoader}
\alias{pgxLoader}
\title{Load data from Progenetix database via the Beacon v2 API with some extensions}
\usage{
pgxLoader(
  type = NULL,
  output = NULL,
  biosample_id = NULL,
  individual_id = NULL,
  filters = NULL,
  limit = 0,
  skip = 0,
  dataset = NULL,
  codematches = FALSE,
  filter_pattern = NULL,
  save_file = FALSE,
  filename = "variants.tsv",
  use_https = TRUE,
  domain = "progenetix.org",
  entry_point = "beacon",
  num_cores = 1
)
}
\arguments{
\item{type}{A string specifying the type of output data. Available options include:
\itemize{
\item \code{"individuals"}: Returns information about individuals.
\item \code{"biosamples"}: Returns information about biosamples.
\item \code{"analyses"}: Returns information about analyses.
\item \code{"g_variants"}: Returns variants data.
\item \code{"filtering_terms"}: Returns available filtering terms.
\item \code{"counts"}: Returns the count of results based on the specified filters.
\item \code{"cnv_frequency"}: Returns precomputed CNV frequency data from Progenetix.
\item \code{"cnv_fraction"}: Returns CNV fraction per sample based on Progenetix data.
}}

\item{output}{A string specifying the format of the output data. The available options depend on the value of the \code{type} parameter:
\itemize{
\item If \code{type} is \code{"g_variants"}, the available options are \code{NULL} (default), \code{"pgxseg"}, or \code{"seg"}.
\item If \code{type} is \code{"cnv_frequency"}, the available options are \code{"pgxfreq"} (default) or \code{"pgxmatrix"}.
\item If \code{type} is \code{"cnv_fraction"}, the available options are \code{NULL} (default) or \code{"pgxmatrix"}.
}}

\item{biosample_id}{Identifiers used in the query database for identifying biosamples.}

\item{individual_id}{Identifiers used in the query database for identifying individuals.}

\item{filters}{Identifiers used in public repositories, bio-ontology terms, or custom terms such as \code{c("NCIT:C7376", "pgx:icdom-85003")}.
When multiple filters are used, they are combined using AND logic when the parameter \code{type} is \code{"individuals"}, \code{"biosamples"}, or \code{"analyses"}; OR logic when the parameter \code{type} is \code{"counts"} or \code{"cnv_frequency"}.}

\item{limit}{Integer to specify the number of returned profiles. Default is \code{0} (return all).}

\item{skip}{An integer specifying the number of profiles to skip. For example, if \code{skip = 2} and \code{limit = 500}, the first \code{2 * 500 = 1000} profiles are skipped,
and the next 500 profiles are returned. Default is \code{0}, meaning no profiles are skipped.}

\item{dataset}{Datasets to query from the Beacon response. Default is \code{NULL}, which includes results from all datasets.}

\item{codematches}{A logical value indicating whether to exclude samples from child concepts of the specified filters in the ontology tree.
If \code{TRUE}, only samples that exactly match the specified filters will be included. This parameter should not be used when \code{filters} include ontology-irrelevant filters, such as pubmed or cohort identifiers.
Default is \code{FALSE}. This option is applicable only when querying data resources are Progenetix or cancercelllines.org.}

\item{filter_pattern}{Optional string pattern to match against the \code{label} field of available filters. Only used when the parameter \code{type} is \code{"filtering_terms"}. Default is \code{NULL}, which includes all filters.}

\item{save_file}{A logical value determining whether to save variant data as a local file instead of direct return. Only used when the parameter \code{type} is \code{"g_variants"}. Default is \code{FALSE}.}

\item{filename}{A string specifying the path and name of the file to be saved. This parameter is used only when \code{save_file} is set to \code{TRUE}. The default value is \code{"variants.tsv"}, saved in the current working directory.}

\item{use_https}{A logical value indicating whether to use the HTTPS protocol. If \code{TRUE}, the domain will be prefixed with \code{"https://"}; otherwise, \code{"http://"} will be used. Default is \code{TRUE}.}

\item{domain}{The domain of the query data resource. Default is \code{"progenetix.org"}.}

\item{entry_point}{The entry point of the Beacon v2 API. Default is \code{"beacon"}, resulting in the default endpoint being "https://progenetix.org/beacon".}

\item{num_cores}{An integer specifying the number of cores to use for parallel processing during Beacon v2 phenotypic/meta-data queries from multiple domains or variant data queries from multiple biosamples. Default is \code{1}.}
}
\value{
Data from Progenetix database and other Beacon v2-compatible resources
}
\description{
This function loads various data from \code{Progenetix} database via the Beacon v2 API with some extensions (BeaconPlus). It is also compatible with other Beacon v2-compliant resources.
}
\examples{
## query metadata
biosamples <- pgxLoader(type="biosamples", filters = "NCIT:C3512")
## query variants
seg <- pgxLoader(type="g_variants", biosample_id = "pgxbs-kftvgx4y")
## query CNV frequency
freq <- pgxLoader(type="cnv_frequency", output ='pgxfreq', filters="NCIT:C3512")
}
