% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{saveDict}
\alias{saveDict}
\title{Write a PGCA dictionary to a text file}
\usage{
saveDict(dict, file = stop("`file` must be specified"), ...)
}
\arguments{
\item{dict}{a PGCA dictionary.}

\item{file}{either a character string naming a file or a
\code{\link[base]{connection}} open for writing.
\code{""} indicates output to the console.}

\item{...}{further arguments passed to \code{\link[utils]{write.table}}.}
}
\value{
This function returns \code{NULL} invisibly.
}
\description{
Write the dictionary to a text file using the
\code{\link[utils]{write.table}} function. By default, a tab-separated file
is written, but this can be changed
by changing the arguments to \code{\link[utils]{write.table}}.
}
\examples{
# Build accession dictionary from all files in a directory
dict <- pgcaDict(
         system.file("extdata", package="pgca"),
         col.mapping=c(gene.symbol="Gene_Symbol")
)

# Save dictionary to a temporary file
dictOutFile <- tempfile()
saveDict(dict, file=dictOutFile)

# Change the separator string to a tab
dictOutFile <- tempfile()
saveDict(dict, file=dictOutFile, sep="\\t")
}
\seealso{
\code{\link{pgcaDict}} to create the dictionary, and
     \code{\link{applyDict}} to apply the dictionary for translating
     data files.
}
