% Generated by roxygen2 (4.0.1): do not edit by hand
\name{pepXML2tab}
\alias{pepXML2tab}
\title{Generate a data frame objects from a pepXML file.}
\usage{
pepXML2tab(pepxml, ...)
}
\arguments{
\item{pepxml}{a character contains the path and name of a pepXML file}

\item{...}{additional arguments}
}
\value{
a data frame object, each row represent a PSM
    (peptide spectrum match) from the pepXML file
}
\description{
The pepXML2tab() function generates a data frame from a pepXML file.
}
\details{
Read peptide identification from pepXML file into an data frame object.
}
\examples{
## MyriMatch example
pepxml <- system.file("extdata/pepxml", "Myrimatch.pepXML",
    package="pepXMLTab")
tttt <- pepXML2tab(pepxml)

## Mascot example
pepxml <- system.file("extdata/pepxml", "Mascot.pepXML",
    package="pepXMLTab")
tttt <- pepXML2tab(pepxml)

## SEQUEST example
pepxml <- system.file("extdata/pepxml", "SEQUEST.pepXML",
    package="pepXMLTab")
tttt <- pepXML2tab(pepxml)

## XTandem example
pepxml <- system.file("extdata/pepxml", "XTandem.pepXML",
    package="pepXMLTab")
tttt <- pepXML2tab(pepxml)
}
\author{
Xiaojing Wang
}

