% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GUI_utils.R
\name{load_annotation_from_file_UI_helper}
\alias{load_annotation_from_file_UI_helper}
\title{UI data import helper - check loaded annotation}
\usage{
load_annotation_from_file_UI_helper(annotationPath)
}
\arguments{
\item{annotationPath}{(str) Path to a RData file containing a
peakPantheRAnnotation names `annotationObject`}
}
\value{
(peakPantheRAnnotation) Object loaded from file
}
\description{
Load a .RData file (check it exists) and that a peakPantheRAnnotation named
"annotationObject" is present. Returns the annotation if everything is valid
}
\examples{
## Initialise a peakPantheRAnnotation object with 3 samples and 2 compounds

## Inputs
# spectraPaths
spectraPaths <- c('./path/file1', './path/file2', './path/file3')

# targetFeatTable
targetFeatTable <- data.frame(matrix(vector(), 2, 8, dimnames=list(c(),
                    c('cpdID','cpdName','rtMin','rt','rtMax','mzMin','mz',
                    'mzMax'))), stringsAsFactors=FALSE)
targetFeatTable[1,] <- c('ID-1', 'Cpd 1', 3310., 3344.888, 3390., 522.194778,
                        522.2, 522.205222)
targetFeatTable[2,] <- c('ID-2', 'Cpd 2', 3280., 3385.577, 3440., 496.195038,
                        496.2, 496.204962)
targetFeatTable[,c(3:8)] <- vapply(targetFeatTable[,c(3:8)], as.numeric,
                                    FUN.VALUE=numeric(2))

annotationObject <- peakPantheRAnnotation(spectraPaths=spectraPaths,
                                        targetFeatTable=targetFeatTable)

# save annotation to disk
annotPath <- tempfile(pattern="file", tmpdir=tempdir(), fileext='.RData')
save(annotationObject, file=annotPath, compress=TRUE)

# Load annotation
load_annotation_from_file_UI_helper(annotationPath = annotPath)
# An object of class peakPantheRAnnotation
#   2 compounds in 3 samples.
#   updated ROI do not exist (uROI)
#   does not use updated ROI (uROI)
#   does not use fallback integration regions (FIR)
#   is not annotated
}
