% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathnetCreate.R
\name{pathnetCreate}
\alias{pathnetCreate}
\title{Create a pathway network from enrichment results and a pathway
interaction foundation}
\usage{
pathnetCreate(
  pathwayEnrichmentResult,
  columnId = "pathwayId",
  columnP = "pValueAdjusted",
  foundation,
  trim = TRUE,
  trimOrder = 1
)
}
\arguments{
\item{pathwayEnrichmentResult}{Data frame of results from
\code{pathwayEnrichment} run with Sigora or ReactomePA (should be based on
Reactome data).}

\item{columnId}{Character; column containing the Reactome pathway IDs.
Defaults to "pathwayID".}

\item{columnP}{Character; column containing the adjusted p values. Defaults
to "pValueAdjusted".}

\item{foundation}{List of pathway pairs to use in constructing a network.
Typically this will be the output from \code{createFoundation}.}

\item{trim}{Remove independent subgraphs which don't contain any enriched
pathways (default is \code{TRUE}).}

\item{trimOrder}{Order to use when removing subgraphs; Higher values will
keep more non-enriched pathway nodes. Defaults to \code{1}.}
}
\value{
A pathway network as a "tidygraph" object, with the following columns
for nodes:
\item{pathwayId}{Reactome pathway ID}
\item{pathwayName}{Reactome pathway name}
\item{comparison}{Name of source comparison, if this pathway was enriched}
\item{direction}{Whether an enriched pathway was found in all genes or up-
or down-regulated genes}
\item{pValue}{Nominal p-value from the enrichment result}
\item{pValueAdjusted}{Corrected p-value from the enrichment}
\item{genes}{Candidate genes for the given pathway if it was enriched}
\item{numCandidateGenes}{Number of candidate genes}
\item{numBgGenes}{Number of background genes}
\item{geneRatio}{Ratio of candidate and background genes}
\item{totalGenes}{Total number of DE genes tested, for an enriched pathway}
\item{topLevelPathway}{Highest level Reactome term for a given pathway}
\item{groupedPathway}{Custom pathway category used in visualizations}

For edges, the following information is also included:
\item{from}{Starting node (row number) for the edge}
\item{to}{Ending node (row number) for the edge}
\item{similarity}{Similarity of two nodes/pathways}
\item{distance}{Inverse of similarity}
}
\description{
Creates a tidygraph network object from the provided pathway
information, ready to be visualized with \code{pathnetGGraph} or
\code{pathnetVisNetwork}.
}
\details{
With the "trim" option enabled, nodes (pathways) and subgraphs which
are not sufficiently connected to enriched pathways will be removed. How
aggressively this is done can be controlled via the \code{trimOrder} argument,
and the optimal value will depend on the number of enriched pathways and
the number of interacting pathways (i.e. number of rows in "foundation").
}
\examples{
data("sigoraDatabase", "sigoraExamples")

pathwayDistancesJaccard <- getPathwayDistances(
    pathwayData=dplyr::slice_head(
        dplyr::arrange(sigoraDatabase, pathwayId),
        prop=0.05
    ),
    distMethod="jaccard"
)

startingPathways <- pathnetFoundation(
    mat=pathwayDistancesJaccard,
    maxDistance=0.8
)

pathnetCreate(
    pathwayEnrichmentResult=sigoraExamples[grepl(
        "Pos",
        sigoraExamples$comparison
    ), ],
    foundation=startingPathways,
    trim=TRUE,
    trimOrder=1
)

}
\seealso{
\url{https://github.com/hancockinformatics/pathlinkR}
}
