% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NormalizeCounts.R
\name{NormalizeCounts}
\alias{NormalizeCounts}
\title{Extract and normalize gene expression counts for a SingleCellExperiment object}
\usage{
NormalizeCounts(obj, scale_factor = 10000)
}
\arguments{
\item{obj}{The SingleCellExperiment object.}

\item{scale_factor}{Feature counts for each cell are divided by the total counts for 
that cell and multiplied by the scale.factor, and then natural-log transformed using log1p.}
}
\value{
A normalized gene expression counts matrix.
}
\description{
This function helps normalize the gene expression count matrix for a SingleCellExperiment object.
}
\examples{
data(SimDataSce)
counts_mat <- NormalizeCounts(SimDataSce)


}
