% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{importPandaMatlab}
\alias{importPandaMatlab}
\title{Panda Matlab importer}
\usage{
importPandaMatlab(dir = getwd(), celldata = "celldata.dat")
}
\arguments{
\item{dir}{Working directory to search for the numeric files.}

\item{celldata}{Name of the 'celldata.dat' file.}
}
\value{
Two column vector of "regulator" and "target"
}
\description{
Imports the files from the \code{exportPanda.m} file.
}
\examples{

\donttest{
# determine gene degree
 pandaFiles = importPandaMatlab()
 indegree <- ddply(pandaFiles[,2:ncol(pandaFiles)], .(targer), numcolwise(sum))
 row.names(indegree) <- indegree[,1]
 indegree <- indegree[,-1]
 # to export the file
 networkfiles = list.files(pattern="numeric")
 write.table(indegree,paste("indegree_",networkfiles,sep=""),
             sep="\\t",quote=F,row.names=T,col.names=T)
}

}
