% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comparison_functions.R
\name{calcDegreeDifference}
\alias{calcDegreeDifference}
\title{Calculate difference in degrees}
\usage{
calcDegreeDifference(x, y, type = c("tf", "gene"), filter = FALSE,
  trim = FALSE, ...)
}
\arguments{
\item{x}{An object of class "panda" or matrix}

\item{y}{A second object of class "panda" or matrix}

\item{type}{Character string - 'tf' or 'gene'}

\item{filter}{Boolean to force negative degrees to zero}

\item{trim}{Boolean to trim using topedges or not at a cutoff (weights become binary 1,0)}

\item{...}{Options to be passed to topedges function}
}
\description{
Calculates the transcription factor out-degree or
gene in-degree for two different panda regulatory networks.
This is useful in comparing networks from two phenotypes.
}
\examples{
\donttest{
data(pandaToyData)
pandaRes <- panda(pandaToyData$motif,
           pandaToyData$expression,pandaToyData$ppi,hamming=.001,progress=TRUE)
pandaRes2 <- panda(pandaToyData$motif,
           pandaToyData$expression,pandaToyData$ppi,hamming=.1,progress=TRUE)
calcDegreeDifference(pandaRes,pandaRes2)
calcDegreeDifference(pandaRes,pandaRes2,trim=TRUE,cutoff=1.5)
}

}
