% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotDist}
\alias{plotDist}
\title{Plots the distribution of features across fractions}
\usage{
plotDist(
  object,
  markers,
  fcol = NULL,
  mcol = "steelblue",
  pcol = getUnknowncol(),
  alpha = 0.3,
  type = "b",
  lty = 1,
  fractions = sampleNames(object),
  ylab = "Intensity",
  xlab = "Fractions",
  ylim,
  unknown = "unknown",
  ...
)
}
\arguments{
\item{object}{An instance of class \code{MSnSet}.}

\item{markers}{A \code{character}, \code{numeric} or
\code{logical} of appropriate length and or content used to
subset \code{object} and define the organelle markers.}

\item{fcol}{Feature meta-data label (fData column name) defining
the groups to be differentiated using different colours. If
\code{NULL} (default) ignored and \code{mcol} and \code{pcol}
are used.}

\item{mcol}{A \code{character} define the colour of the marker
features.  Default is \code{"steelblue"}.}

\item{pcol}{A \code{character} define the colour of the
non-markers features.  Default is the colour used for features
of unknown localisation, as returned by
\code{\link{getUnknowncol}}.}

\item{alpha}{A numeric defining the alpha channel (transparency)
of the points, where \code{0 <= alpha <= 1}, 0 and 1 being
completely transparent and opaque.}

\item{type}{Character string defining the type of lines. For
example \code{"p"} for points, \code{"l"} for lines,
\code{"b"} for both. See \code{plot} for all possible types.}

\item{lty}{Vector of line types for the marker profiles. Default
is 1 (solid). See \code{\link{par}} for details.}

\item{fractions}{A \code{character} defining the \code{phenoData}
variable to be used to label the fraction along the x
axis. Default is to use \code{sampleNames(object)}.}

\item{ylab}{y-axis label. Default is "Intensity".}

\item{xlab}{x-axis label. Default is "Fractions".}

\item{ylim}{A numeric vector of length 2, giving the y coordinates
range.}

\item{unknown}{Character defining how unlabelled points are defined 
default is "unknown".}

\item{...}{Additional parameters passed to \code{\link{plot}}.}
}
\value{
Used for its side effect of producing a feature
    distribution plot. Invisibly returns the data matrix.
}
\description{
Produces a line plot showing the feature abundances
across the fractions.
}
\examples{
library("pRolocdata")
data(tan2009r1)
j <- which(fData(tan2009r1)$markers == "mitochondrion")
i <- which(fData(tan2009r1)$PLSDA == "mitochondrion")
plotDist(tan2009r1[i, ], markers = featureNames(tan2009r1)[j])
plotDist(tan2009r1[i, ], markers = featureNames(tan2009r1)[j],
         fractions = "Fractions")
## plot and colour all marker profiles
tanmrk <- markerMSnSet(tan2009r1)
plotDist(tanmrk, fcol = "markers")
}
\author{
Laurent Gatto
}
