% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R, R/plotting3.R
\name{highlightOnPlot}
\alias{highlightOnPlot}
\alias{highlightOnPlot3D}
\title{Highlight features of interest on a spatial proteomics plot}
\usage{
highlightOnPlot(object, foi, labels, args = list(), ...)

highlightOnPlot3D(object, foi, labels, args = list(), radius = 0.1 * 3, ...)
}
\arguments{
\item{object}{The main dataset described as an \code{MSnSet} or a
\code{matrix} with the coordinates of the features on the PCA
plot produced (and invisibly returned) by \code{plot2D}.}

\item{foi}{An instance of \code{\linkS4class{FeaturesOfInterest}},
or, alternatively, a \code{character} of feautre names.}

\item{labels}{A \code{character} of length 1 with a feature
variable name to be used to label the features of
interest. This is only valid if \code{object} is an
\code{MSnSet}. Alternatively, if \code{TRUE}, then
\code{featureNames(object)} (or \code{rownames(object)}, if
\code{object} is a \code{matrix}) are used. Default is
missing, which does not add any label.s}

\item{args}{A named list of arguments to be passed to
\code{plot2D} if the PCA coordinates are to be
calculated. Ignored if the PCA coordinates are passed
directly, i.e. \code{object} is a \code{matrix}.}

\item{...}{Additional parameters passed to \code{points} or
\code{text} (when \code{labels} is \code{TRUE}) when adding to
\code{plot2D}, or \code{spheres3d} or \code{text3d} when
adding the \code{plot3D}}

\item{radius}{Radius of the spheres to be added to the
visualisation produced by \code{plot3D}. Default is 0.3 (i.e
\code{plot3D}'s \code{radius1} * 3), to emphasise the features
with regard to uknown (\code{radius1 = 0.1}) and marker
(\code{radius1} * 2) features.}
}
\value{
NULL; used for its side effects.
}
\description{
Highlights a set of features of interest given as a
\code{FeaturesOfInterest} instance on a PCA plot produced by
\code{plot2D} or \code{plot3D}. If none of the features of interest
are found in the \code{MSnset}'s \code{featureNames}, an warning
is thrown.
}
\examples{
library("pRolocdata")
data("tan2009r1")
x <- FeaturesOfInterest(description = "A test set of features of interest",
                        fnames = featureNames(tan2009r1)[1:10],
                        object = tan2009r1)

## using FeaturesOfInterest or feature names
par(mfrow = c(2, 1))
plot2D(tan2009r1)
highlightOnPlot(tan2009r1, x)
plot2D(tan2009r1)
highlightOnPlot(tan2009r1, featureNames(tan2009r1)[1:10])

.pca <- plot2D(tan2009r1)
head(.pca)
highlightOnPlot(.pca, x, col = "red")
highlightOnPlot(tan2009r1, x, col = "red", cex = 1.5)
highlightOnPlot(tan2009r1, x, labels = TRUE)

.pca <- plot2D(tan2009r1, dims = c(1, 3))
highlightOnPlot(.pca, x, pch = "+", dims = c(1, 3))
highlightOnPlot(tan2009r1, x, args = list(dims = c(1, 3)))

.pca2 <- plot2D(tan2009r1, mirrorX = TRUE, dims = c(1, 3))
## previous pca matrix, need to mirror X axis
highlightOnPlot(.pca, x, pch = "+", args = list(mirrorX = TRUE))
## new pca matrix, with X mirrors (and 1st and 3rd PCs)
highlightOnPlot(.pca2, x, col = "red")

plot2D(tan2009r1)
highlightOnPlot(tan2009r1, x)
highlightOnPlot(tan2009r1, x, labels = TRUE, pos = 3)
highlightOnPlot(tan2009r1, x, labels = "Flybase.Symbol", pos = 1)

## in 3 dimensions
if (interactive()) {
  plot3D(tan2009r1, radius1 = 0.05)
  highlightOnPlot3D(tan2009r1, x, labels = TRUE)
  highlightOnPlot3D(tan2009r1, x)
}
}
\author{
Laurent Gatto
}
