% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterdist-functions.R
\name{clustDist}
\alias{clustDist}
\title{Pairwise Distance Computation for Protein Information Sets}
\usage{
clustDist(object, k = 1:5, fcol = "GOAnnotations", n = 5, verbose = TRUE, seed)
}
\arguments{
\item{object}{An instance of class \code{"\linkS4class{MSnSet}"}.}

\item{k}{The number of clusters to try fitting to the protein set. 
Default is \code{k = 1:5}.}

\item{fcol}{The feature meta-data containing matrix of protein sets/
marker definitions. Default is \code{GOAnnotations}.}

\item{n}{The minimum number of proteins per set. If protein sets
contain less than \code{n} instances they will be ignored. 
Defualt is 5.}

\item{verbose}{A logical defining whether a progress bar is displayed.}

\item{seed}{An optional seed for the random number generator.}
}
\value{
An instance of \code{"\linkS4class{ClustDistList}"} containing
a \code{"\linkS4class{ClustDist}"} instance for every protein set, which
summarises the algorithm information such as the number of k's tested 
for the kmeans, and mean and normalised pairwise Euclidean distances 
per numer of component clusters tested.
}
\description{
This function computes the mean (normalised) pairwise
distances for pre-defined sets of proteins.
}
\details{
The input to the function is a \code{MSnSet} dataset 
containing a matrix appended to the feature data slot 
identifying the membership of protein instances to 
a pre-defined set(s) e.g. a specific Gene Ontology term etc.

For each protein set, the \code{clustDist} function (i) 
extracts all instances belonging to the set, (ii) using 
the \code{kmeans} algorithm fits and tests \code{k = c(1:5)} 
(default) cluster components to each set, (iii) calculates 
the mean pairwise distance for each \code{k} tested.

Note: currently distances are calcualted in Euclidean space, 
but other distance metrics will be supported in the future). 

The output is a \code{list} of \code{ClustDist} objects, 
one per information cluster. The \code{ClustDist} 
class summarises the algorithm information such as the number of k's 
tested for the kmeans, and mean and normalised pairwise Euclidean 
distances per numer of component clusters tested. See \code{?ClustDist}
for more details.
}
\examples{
library(pRolocdata)
data(dunkley2006)
## Convert annotation data e.g. markers, to a matrix e.g. MM
xx <- mrkVecToMat(dunkley2006, vfcol = "markers", mfcol = "MM")
## get distances for protein sets 
dd <- clustDist(xx, fcol = "MM", k = 1:3)
## plot clusters for first 'ClustDist' object 
## in the 'ClustDistList'
plot(dd[[1]], xx)
## plot normalised distances for all protein sets 
plot(dd)
## plot mean distances for all protein sets 
plot(dd, method = "mean")
##' ## plot raw distances for all protein sets 
plot(dd, method = "raw")
## Extract normalised distances
## Normalisation factor default is n^1/3
minDist <- getNormDist(dd)
## Get new order according to lowest distance
o <- order(minDist)
## Re-order annotations 
fData(xx)$MM <- fData(xx)$MM[, o]
if (interactive()) {
pRolocVis(xx, fcol = "MM")
}
}
\seealso{
For class definitions see \code{"\linkS4class{ClustDistList}"} 
and \code{"\linkS4class{ClustDist}"}.
}
\author{
Lisa Breckels
}
