% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{classWeights}
\alias{classWeights}
\title{Calculate class weights}
\usage{
classWeights(object, fcol = "markers")
}
\arguments{
\item{object}{An instance of class \code{MSnSet}}

\item{fcol}{The name of the features to be weighted}
}
\value{
A \code{table} of class weights
}
\description{
Calculates class weights to be used for parameter optimisation and
classification such as \code{\link{svmOptimisation}} or
\code{\link{svmClassification}} - see the \emph{pRoloc tutorial}
vignette for an example. The weights are calculated for all
non-\emph{unknown} classes the inverse of the number of
observations.
}
\examples{
library("pRolocdata")
data(hyperLOPIT2015)
classWeights(hyperLOPIT2015)
data(dunkley2006)
classWeights(dunkley2006)
}
\author{
Laurent Gatto
}
