% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tclustWithInitialization.R
\name{tclustWithInitialization}
\alias{tclustWithInitialization}
\title{tclustWithInitialization}
\usage{
tclustWithInitialization(
  initialization,
  cytometry,
  i.sol.type = "points",
  trimming = 0.05,
  restr.fact = 1000
)
}
\arguments{
\item{initialization}{Initial solution for parameters provided by the user. Can be a matrix of data containing observations anc cluster assignations or can be a list spesifying a multivariate mixture of gaussians.}

\item{cytometry}{A matrix or data.frame of dimension n x p, containing the observations (row-wise).}

\item{i.sol.type}{Type of initial solutions in c('points', 'barycenters'). 'points' refers to a classified data matrix, while 'barycenters' to a multivariate mixture.}

\item{trimming}{The proportion of observations to be trimmed.}

\item{restr.fact}{The constant restr.fact >= 1 constrains the allowed differences among group scatters. Larger values imply larger differences of group scatters, a value of 1 specifies the strongest restriction.}
}
\value{
A list with entries:
\describe{
 \item{cluster}{A numerical vector of size n containing the cluster assignment for each observation. Cluster names are integer numbers from 1 to k, 0 indicates trimmed observations.}
 \item{n_clus}{Number of clusters actually found.}
 \item{obj}{he value of the objective function of the best (returned) solution.}
}
}
\description{
A wrapper for the function tclust_H.
}
\examples{
x <- rbind(matrix(rnorm(100), ncol = 2), matrix(rnorm(100) + 2, ncol = 2),
        matrix(rnorm(100) + 4, ncol = 2))
## robust cluster obtention from a sample x asking for 3 clusters,
## trimming level 0.05 and constrain level 12
k <- 3; alpha <- 0.05; restr.fact <- 12
output = tclust_H(x = x, k = k, alpha = alpha, nstart = 50, iter.max = 20,
                 restr = 'eigen', restr.fact = restr.fact, sol_ini_p = FALSE, sol_ini = NA,
                 equal.weights = FALSE, trace = 0, zero.tol = 1e-16)
## cluster assigment
output2 <- tclustWithInitialization(data.frame(x, output$cluster), x, 'points', 0.05, 10)

}
