% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsva.R
\docType{methods}
\name{gsva}
\alias{gsva}
\alias{gsva,ExpressionSet,GeneSetCollection-method}
\alias{gsva,ExpressionSet,list-method}
\alias{gsva,matrix,GeneSetCollection-method}
\alias{gsva,matrix,list-method}
\title{gsva}
\usage{
gsva(expr, gset.idx.list, ...)

\S4method{gsva}{ExpressionSet,list}(expr, gset.idx.list, annotation,
  method = c("gsva", "ssgsea", "zscore", "plage"), rnaseq = FALSE,
  abs.ranking = FALSE, min.sz = 1, max.sz = Inf, no.bootstraps = 0,
  bootstrap.percent = 0.632, parallel.sz = 0, parallel.type = "SOCK",
  mx.diff = TRUE, tau = switch(method, gsva = 1, ssgsea = 0.25, NA),
  kernel = TRUE, ssgsea.norm = TRUE, verbose = TRUE,
  is.gset.list.up.down = FALSE)

\S4method{gsva}{ExpressionSet,GeneSetCollection}(expr, gset.idx.list,
  annotation, method = c("gsva", "ssgsea", "zscore", "plage"),
  rnaseq = FALSE, abs.ranking = FALSE, min.sz = 1, max.sz = Inf,
  no.bootstraps = 0, bootstrap.percent = 0.632, parallel.sz = 0,
  parallel.type = "SOCK", mx.diff = TRUE, tau = switch(method, gsva = 1,
  ssgsea = 0.25, NA), kernel = TRUE, ssgsea.norm = TRUE, verbose = TRUE,
  is.gset.list.up.down = FALSE)

\S4method{gsva}{matrix,GeneSetCollection}(expr, gset.idx.list, annotation,
  method = c("gsva", "ssgsea", "zscore", "plage"), rnaseq = FALSE,
  abs.ranking = FALSE, min.sz = 1, max.sz = Inf, no.bootstraps = 0,
  bootstrap.percent = 0.632, parallel.sz = 0, parallel.type = "SOCK",
  mx.diff = TRUE, tau = switch(method, gsva = 1, ssgsea = 0.25, NA),
  kernel = TRUE, ssgsea.norm = TRUE, verbose = TRUE,
  is.gset.list.up.down = FALSE)

\S4method{gsva}{matrix,list}(expr, gset.idx.list, annotation,
  method = c("gsva", "ssgsea", "zscore", "plage"), rnaseq = FALSE,
  abs.ranking = FALSE, min.sz = 1, max.sz = Inf, no.bootstraps = 0,
  bootstrap.percent = 0.632, parallel.sz = 0, parallel.type = "SOCK",
  mx.diff = TRUE, tau = switch(method, gsva = 1, ssgsea = 0.25, NA),
  kernel = TRUE, ssgsea.norm = TRUE, verbose = TRUE,
  is.gset.list.up.down = FALSE)
}
\arguments{
\item{expr}{Gene expression data which can be given either as an \code{ExpressionSet}
object or as a matrix of expression values where rows correspond
to genes and columns correspond to samples.}

\item{gset.idx.list}{Gene sets provided either as a \code{list} object or as a
\code{GeneSetCollection} object.}

\item{...}{other optional arguments.}

\item{annotation}{In the case of calling \code{gsva()} with expression data in a \code{matrix}
and gene sets as a \code{GeneSetCollection} object, the \code{annotation} argument
can be used to supply the name of the Bioconductor package that contains
annotations for the class of gene identifiers occurring in the row names of
the expression data matrix. By default \code{gsva()} will try to match the
identifiers in \code{expr} to the identifiers in \code{gset.idx.list} just as
they are, unless the \code{annotation} argument is set.}

\item{method}{Method to employ in the estimation of gene-set enrichment scores per sample. By default
this is set to \code{gsva} (Hanzelmann et al, 2013) and other options are
\code{ssgsea} (Barbie et al, 2009), \code{zscore} (Lee et al, 2008) or \code{plage}
(Tomfohr et al, 2005). The latter two standardize first expression profiles into z-scores
over the samples and, in the case of \code{zscore}, it combines them together as their sum
divided by the square-root of the size of the gene set,
while in the case of \code{plage} they are used to calculate the singular value decomposition
(SVD) over the genes in the gene set and use the coefficients of the first right-singular vector
as pathway activity profile.}

\item{rnaseq}{Flag to inform whether the input gene expression data comes from microarray
(\code{rnaseq=FALSE}, default) or RNA-Seq (\code{rnaseq=TRUE}) experiments.}

\item{abs.ranking}{Flag to determine whether genes should be ranked according to
their sign (\code{abs.ranking=FALSE}) or by absolute value (\code{abs.ranking=TRUE}).
In the latter, pathways with genes enriched on either extreme
(high or low) will be regarded as 'highly' activated.}

\item{min.sz}{Minimum size of the resulting gene sets.}

\item{max.sz}{Maximum size of the resulting gene sets.}

\item{no.bootstraps}{Number of bootstrap iterations to perform.}

\item{bootstrap.percent}{.632 is the ideal percent samples bootstrapped.}

\item{parallel.sz}{Number of processors to use when doing the calculations in parallel.
This requires to previously load either the \code{parallel} or the
\code{snow} library. If \code{parallel} is loaded and this argument
is left with its default value (\code{parallel.sz=0}) then it will use
all available core processors unless we set this argument with a
smaller number. If \code{snow} is loaded then we must set this argument
to a positive integer number that specifies the number of processors to
employ in the parallel calculation.}

\item{parallel.type}{Type of cluster architecture when using \code{snow}.}

\item{mx.diff}{Offers two approaches to calculate the enrichment statistic (ES)
from the KS random walk statistic. \code{mx.diff=FALSE}: ES is calculated as
the maximum distance of the random walk from 0. \code{mx.diff=TRUE} (default): ES
is calculated as the magnitude difference between the largest positive
and negative random walk deviations.}

\item{tau}{Exponent defining the weight of the tail in the random walk performed by both the \code{gsva}
(Hanzelmann et al., 2013) and the \code{ssgsea} (Barbie et al., 2009) methods. By default,
this \code{tau=1} when \code{method="gsva"} and \code{tau=0.25} when \code{method="ssgsea"} just
as specified by Barbie et al. (2009) where this parameter is called \code{alpha}.}

\item{kernel}{Logical, set to \code{TRUE} when the GSVA method employes a kernel non-parametric
estimation of the empirical cumulative distribution function (default) and \code{FALSE}
when this function is directly estimated from the observed data. This last option is
justified in the limit of the size of the sample by the so-called Glivenko-Cantelli theorem.}

\item{ssgsea.norm}{Logical, set to \code{TRUE} (default) with \code{method="ssgsea"} runs the SSGSEA method
from Barbie et al. (2009) normalizing the scores by the absolute difference between
the minimum and the maximum, as described in their paper. When \code{ssgsea.norm=FALSE}
this last normalization step is skipped.}

\item{verbose}{Gives information about each calculation step. Default: \code{FALSE}.}

\item{is.gset.list.up.down}{logical. Is the gene list divided into up/down sublists?
Please note that it is important to name the up-regulated gene set list 'up', and
the down-regulated gene set list to 'down', if this argument is used (e.g
gset = list(up = up_gset, down = down_gset))}
}
\value{
returns gene set enrichment scores for each sample and gene set
}
\description{
Gene Set Variation Analysis
}
\section{Methods (by class)}{
\itemize{
\item \code{expr = ExpressionSet,gset.idx.list = list}: Method for ExpressionSet and list

\item \code{expr = ExpressionSet,gset.idx.list = GeneSetCollection}: Method for ExpressionSet and GeneSetCollection

\item \code{expr = matrix,gset.idx.list = GeneSetCollection}: Method for matrix and GeneSetCollection

\item \code{expr = matrix,gset.idx.list = list}: Method for matrix and list
}}
\examples{
data("Maupin")
names(maupin)
geneSet<- maupin$sig$EntrezID    #Symbol  ##EntrezID # both up and down genes:
up_sig<- maupin$sig[maupin$sig$upDown == "up",]
d_sig<- maupin$sig[maupin$sig$upDown == "down",]
u_geneSet<- up_sig$EntrezID   #Symbol   # up_sig$Symbol  ## EntrezID
d_geneSet<- d_sig$EntrezID
es.dif <- gsva(maupin$data, list(up = u_geneSet, down= d_geneSet), mx.diff=1,
    verbose=TRUE, abs.ranking=FALSE, is.gset.list.up.down=TRUE, parallel.sz = 1 )$es.obs

}
\seealso{
Hanzelmann, S., Castelo, R., & Guinney, J. (2013). GSVA: gene set variation analysis for
    microarray and RNA-Seq data. BMC Bioinformatics, 14, 7. http://doi.org/10.1186/1471-2105-14-7
}

