% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSampleOutlier.R
\docType{methods}
\name{getSampleOutlier}
\alias{getSampleOutlier}
\alias{getSampleOutlier,OPPARList,nuchar-method}
\alias{getSampleOutlier,matrix,nuchar-method}
\title{Retrieving outlier genes in samples}
\usage{
getSampleOutlier(profileMatrix, sample.name)

\S4method{getSampleOutlier}{matrix,nuchar}(profileMatrix, sample.name)

\S4method{getSampleOutlier}{OPPARList,nuchar}(profileMatrix, sample.name)
}
\arguments{
\item{profileMatrix}{A matrix of 0, -1 and 1 representing outlier genes in samples.
Also an object of type \code{OPPARList}.}

\item{sample.name}{A character vector containing one or more sample names, or a numeric vector
containing sample indices.}
}
\value{
A list of lists. For each given sample, the fuction return
   up-regulated and down-regulated outlier genes.
}
\description{
Returns a list of outlier genes for each given sample
}
\section{Methods (by class)}{
\itemize{
\item \code{profileMatrix = matrix,sample.name = nuchar}: A method for getSampleOutlier

\item \code{profileMatrix = OPPARList,sample.name = nuchar}: A method for getSampleOutlier
}}
\examples{
data(GSE46141)
library(Biobase)
group <- sapply(pData(bcm)$source_name_ch1, function(x){ ifelse(x == "breast",0,1)})
group <- factor(group)
bcm.opa <- opa(bcm,group=group)
# Outlier profile for sample "GSM1124929"
getSampleOutlier(bcm.opa, "GSM1124929")

# Also can use sample index, instead of sample name
getSampleOutlier(bcm.opa, 11)

# A vector of sample names/indices are accepted as well
getSampleOutlier(bcm.opa, c(1,2))
getSampleOutlier(bcm.opa, c("GSM1124929","GSM1124941"))
}

