% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/primers.R
\name{plot_primer_binding_regions,Primers,Templates-method}
\alias{plot_primer_binding_regions,Primers,Templates-method}
\title{Plot of Primer Binding Regions for a Single Primer Set.}
\usage{
\S4method{plot_primer_binding_regions}{Primers,Templates}(
  primers,
  templates,
  direction = c("both", "fw", "rev"),
  group = NULL,
  relation = c("fw", "rev"),
  region.names = c("Binding region", "Amplification region")
)
}
\arguments{
\item{primers}{An object of class \code{Primers} with annotated
primer coverage.}

\item{templates}{An object of class \code{Templates} providing the
template sequences corresponding to \code{primers}.}

\item{direction}{Primer direction}

\item{group}{The template groups for which binding events should
be determined. By default, \code{group} is set to \code{NULL} such that
all templates are considered.}

\item{relation}{A character vector specifying whether binding region data shall
be plotted relative to the forward (\code{fw}) or reverse (\code{rev}) 
target binding regions.}

\item{region.names}{Names for the primer binding region and the amplified region.}
}
\value{
A histogram of primer binding regions.
}
\description{
Plots the primer binding regions in the templates.
}
\keyword{internal}
