% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores.R
\name{score_mbalt}
\alias{score_mbalt}
\title{Computes the total number of Mbp altered.}
\usage{
score_mbalt(segments, kit.coverage, loh.rm = TRUE)
}
\arguments{
\item{segments}{A \code{GRanges} object containing the segments, their copy
number and copy number types.}

\item{kit.coverage}{A \code{GRanges} object containing the regions covered on
each chromosome arm.}

\item{loh.rm}{A boolean (TRUE by default) to indicate whether LOH segments
should be excluded.}
}
\value{
A named list representing the Mbp altered in the sample and the total
 Mbp of the kit.
}
\description{
Computes the total number of Mbp altered.
}
\examples{
score_mbalt(segs.chas_example, oncoscan_na33.cov)
score_mbalt(segs.chas_example, oncoscan_na33.cov, FALSE)
}
