% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module_scatter.R
\name{plotly_scatter_ui}
\alias{plotly_scatter_ui}
\title{Shiny module for scatter plot using plotly - UI}
\usage{
plotly_scatter_ui(id, height = "400px")
}
\arguments{
\item{id}{id}

\item{height}{figure height}
}
\value{
a tagList of UI components
}
\description{
Function should only be used for the developers
}
\examples{
if (interactive()) {
  library(shiny)
  
  # two random variables
  x <- rnorm(30)
  y <- x + rnorm(30, sd = 0.5)
  
  # variables mapped to color, shape and size
  cc <- sample(letters[1:4], replace = TRUE, size = 30) 
  shape <- sample(c("S1", "S2", "S3"), replace = TRUE, size = 30)
  sz <- sample(c(10, 20, 30, replace = TRUE, size = 30))
  
  ui <- fluidPage(
    plotly_scatter_ui("test_scatter")
  )
  
  server <- function(input, output, session) {
    v <- callModule(plotly_scatter_module, id = "test_scatter",
                    # reactive_checkpoint = reactive(FALSE),
                    reactive_param_plotly_scatter = reactive(list(
                      x = x, y = y,
                      color = cc,
                      shape = shape,
                      size = sz,
                      tooltips = paste("A", 1:30)
                    )))
    observe(print(v()))
  }
  shinyApp(ui, server)
  
  
  
  # example beeswarm horizontal
  x <- rnorm(30)
  y <- sample(c("x", "y", "z"), size = 30, replace = TRUE)
  shinyApp(ui, server)
  
  # example beeswarm vertical
  x <- sample(c("x", "y", "z"), size = 30, replace = TRUE)
  y <- rnorm(30)
  shinyApp(ui, server)
  
  # return values 
  x <- c(5, 6, 3, 4, 1, 2)
  y <- c(5, 6, 3, 4, 1, 2)
  ui <- fluidPage(
    plotly_scatter_ui("test_scatter")
  )
  server <- function(input, output, session) {
    v <- callModule(plotly_scatter_module, id = "test_scatter",
                    reactive_param_plotly_scatter = reactive(list(
                      x = x, y = y, tooltips = paste("A", 1:6), highlight = 2:4
                    )))
    
    observe(print(v()))
  }
  shinyApp(ui, server)
}
}
