% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module_scatter.R
\name{plotly_scatter_module}
\alias{plotly_scatter_module}
\title{Shiny module for scatter plot using plotly - Module}
\usage{
plotly_scatter_module(
  id,
  reactive_param_plotly_scatter,
  reactive_regLine = reactive(FALSE),
  reactive_checkpoint = reactive(TRUE),
  htest_var1 = reactive(NULL),
  htest_var2 = reactive(NULL)
)
}
\arguments{
\item{id}{module id}

\item{reactive_param_plotly_scatter}{reactive parammeters for plotly_scatter}

\item{reactive_regLine}{logical show or hide the regression line}

\item{reactive_checkpoint}{checkpoint}

\item{htest_var1}{when the plot is a beeswarmplot, two groups could be selected for two group comparison, this
argument gives the default value. Mainly used for restoring the saved session.}

\item{htest_var2}{see above}
}
\value{
a list containing the information about the selected data points

an reactive object containing the information of selected, brushed points.
}
\description{
Function should only be used for the developers
}
\examples{
if (interactive()) {
  library(shiny)

  # two random variables
  x <- rnorm(30)
  y <- x + rnorm(30, sd = 0.5)

  # variables mapped to color, shape and size
  cc <- sample(letters[1:4], replace = TRUE, size = 30)
  shape <- sample(c("S1", "S2", "S3"), replace = TRUE, size = 30)
  sz <- sample(c(10, 20, 30, replace = TRUE, size = 30))

  ui <- fluidPage(
    plotly_scatter_ui("test_scatter")
  )

  server <- function(input, output, session) {
    v <- plotly_scatter_module("test_scatter",
                    # reactive_checkpoint = reactive(FALSE),
                    reactive_param_plotly_scatter = reactive(list(
                      x = x, y = y,
                      color = cc,
                      shape = shape,
                      size = sz,
                      tooltips = paste("A", 1:30)
                    )))
    observe(print(v()))
  }
  shinyApp(ui, server)



  # example beeswarm horizontal
  x <- rnorm(30)
  y <- sample(c("x", "y", "z"), size = 30, replace = TRUE)
  shinyApp(ui, server)

  # example beeswarm vertical
  x <- sample(c("x", "y", "z"), size = 30, replace = TRUE)
  y <- rnorm(30)
  shinyApp(ui, server)

  # return values
  x <- c(5, 6, 3, 4, 1, 2)
  y <- c(5, 6, 3, 4, 1, 2)
  ui <- fluidPage(
    plotly_scatter_ui("test_scatter")
  )
  server <- function(input, output, session) {
    v <- plotly_scatter_module("test_scatter",
                    reactive_param_plotly_scatter = reactive(list(
                      x = x, y = y, tooltips = paste("A", 1:6), highlight = 2:4
                    )))

    observe(print(v()))
  }
  shinyApp(ui, server)
}
}
