% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proc_doseCurve.R
\name{.modelFormula}
\alias{.modelFormula}
\title{model fitted by drc}
\usage{
.modelFormula(x, b, c = 0, d = 1, e, f = 1)
}
\arguments{
\item{x}{numerical vector of doses/time points/concentrations}

\item{b}{Hill's slope. The Hill's slope refers to the steepness of the curve. It could either be positive or negative.}

\item{c}{Lowest response value.}

\item{d}{Hihgest response value.}

\item{e}{Inflection point. The inflection point is defined as the point on the curve where the curvature changes direction or signs. 
In models where f = 1 (2-4 parameter models), e is EC50.}

\item{f}{Asymmetry factor. When f=1 we have a symmetrical curve around inflection point and so we have a four-parameters logistic equation.}
}
\description{
model fitted by drc
}
\details{
func(x) = c + (d - c) / (1 + (x/e)^b)^f
}
