% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plotCV.R
\name{plot_cv}
\alias{plot_cv}
\alias{plotCV}
\alias{plot_cv,ANY-method}
\title{Functions to create a scree plot for model selection.}
\usage{
plot_cv(x, ...)

\S4method{plot_cv}{ANY}(x, method = "mean", criteria = "dev")

plotCV(x, ..., name = "cv_GMF")
}
\arguments{
\item{x}{Output of \code{\link[sgdGMF]{sgdgmf.cv}},
\code{\link{calculateCVGMF}} or
\code{\link{runCVGMF}}.}

\item{...}{For the \code{plot_cv} generic, additional arguments to
pass to specific methods.}

\item{method}{Function for summarization of the cross-validation over
multiple folds. Default is mean.}

\item{criteria}{The model selection criteria that is plotted. Default is
'dev' (deviance residuals), but 'mae', 'mse', 'aic' and 'bic are possible.}

\item{name}{String specifying the name to be used to obtain the
cross-validation table object in the metadata. It is possible
to specify multiple names if multiple cross-validations have been ran.}
}
\value{
A \code{\link{plot}} object.
}
\description{
Functions to create a scree plot for model selection.
}
\details{
This function plots a screeplot based on the output of
\code{\link{runCVGMF}}, \code{\link{calculateCVGMF}} or
\code{\link[sgdGMF]{sgdgmf.cv}}.
}
\examples{
example_sce <- mockSCE(ncells = 200, ngenes = 100)
example_sce <- runCVGMF(example_sce,
                         exprs_values="counts",
                         family = poisson(),
                         ncomponents = c(1:5))
plotCV(example_sce)
}
\seealso{
\code{\link{runCVGMF}}, to perform the cross-validation.
}
\author{
Alexandre Segers
}
