% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_AllMethods.R, R/ResultSet-tableHist.R
\docType{methods}
\name{tableHits}
\alias{tableHits}
\alias{tableHits,ResultSet-method}
\alias{tableHits}
\title{Counts the number of hits on the results stored in a ResultSet}
\usage{
tableHits(object, th = 0.05)

\S4method{tableHits}{ResultSet}(object, th = 0.05)
}
\arguments{
\item{object}{An object of class \link{ResultSet}}

\item{th}{(default \code{0.05}) Threshold (p-value) to considere a result
as a hit.}
}
\value{
A labeled numeric vector with the exposures and the number of hits.
}
\description{
Given a threshold it counts the number of hits in each result in the
given \link{ResultSet}.
}
\examples{
data("asr", package = "omicRexposome")
tableHits(asr)
}
\seealso{
\code{\link{tableLambda}} for the lambda score per analysys,
\code{\link{plotLambda}} for a graphical representation of
the lambda score per analysys, \code{\link{plotHits}} for a graphical
representation of the hists per analysys
}
