% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_AllMethods.R, R/ResultSet-plotIntegration.R
\docType{methods}
\name{plotIntegration}
\alias{plotIntegration}
\alias{plotIntegration,ResultSet-method}
\alias{plotIntegration}
\title{Function to draw de result of an integration study}
\usage{
plotIntegration(object, cmpX = 1, cmpY = 2, lb.th = 0.2,
  legend.show = TRUE, colors, ...)

\S4method{plotIntegration}{ResultSet}(object, cmpX = 1, cmpY = 2,
  lb.th = 0.2, legend.show = TRUE, colors, ...)
}
\arguments{
\item{object}{An object of class \link{ResultSet} obtained from
\link{crossomics}.}

\item{cmpX}{(default \code{1}) Value of the X-axis when ploting rsults
from \link{mcia}.}

\item{cmpY}{(default \code{2}) Value of the Y-axis when ploting rsults
from \link{mcia}.}

\item{lb.th}{(default \code{0.20}) Threshold to place labels on radar chart
drawn when ploting results from \link{MultiCCA}.}

\item{legend.show}{(default \code{TRUE}) If set to FALSE, right legend
of radar plot is hidden when ploting results from \link{MultiCCA}.}

\item{colors}{(optional) Names vector with the colors sued to draw
each dataset. Used when ploting results from \link{MultiCCA}. If missing,
random colores are chosen.}

\item{...}{Optional arguments are given to \code{plot} from \link{omicade4}
pacage (argument \code{axes} is filled with values from \code{cmpX} and
\code{cmpY}).}
}
\value{
A ggplot2 object
}
\description{
This function draws a plots for the ResultSet from integration function
}
\examples{
data("crs", package = "omicRexposome")
plotIntegration(crs)
}
\seealso{
\code{\link{plotAssociation}} for plotting association results.
\code{\link{crossomics}} to create a \code{ResultSet} to be passed to
this function.
}
