% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentDensity.R
\name{segmentDensity}
\alias{segmentDensity}
\title{Genome segmentation based on feature density}
\usage{
segmentDensity(x, n, L_s = 1e+06, exclude = NULL, type = c("cbs", "hmm"))
}
\arguments{
\item{x}{the input GRanges, e.g. genes}

\item{n}{the number of states}

\item{L_s}{segment length}

\item{exclude}{GRanges of excluded region}

\item{type}{the type of segmentation, either
Circular Binary Segmentation \code{"cbs"}
(which will use 'DNAcopy' to segment) or
Hidden Markov Model \code{"hmm"} (which will use 'RcppHMM').
These packages are not imported by nullranges, but must be installed
by the user}
}
\value{
a GRanges with metadata columns containing:
\itemize{
\item state - segmentation state
\item counts - average number of genes
}
}
\description{
This function allows for various methods (see \code{type})
of segmenting based on the density of features \code{x}.
}
\examples{

n <- 10000
library(GenomicRanges)
gr <- GRanges("chr1", IRanges(round(
  c(runif(n/4,1,991), runif(n/4,1001,3991),
    runif(n/4,4001,4991), runif(n/4,7001,9991))),
  width=10), seqlengths=c(chr1=10000))
gr <- sort(gr)
exclude <- GRanges("chr1", IRanges(5001,6000), seqlengths=c(chr1=10000))
seg <- segmentDensity(gr, n=3, L_s=100, exclude=exclude, type="cbs")

}
\references{
Circular binary segmentation (CBS):

Olshen, A. B., E. S. Venkatraman, R. Lucito, and M. Wigler.
2004. "Circular binary segmentation for the analysis of
array-based DNA copy number data." Biostatistics 5 (4): 557–72.

Hidden Markov Model from RcppHMM:

Roberto A. Cardenas-Ovando, Julieta Noguez, and Claudia Rangel-Escareno.
"Rcpp Hidden Markov Model." CRAN R package.
}
