% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logging.R
\name{log_text}
\alias{log_text}
\title{Log text to the current log file}
\usage{
log_text(text)
}
\arguments{
\item{text}{The text to be logged}
}
\value{
None, the function is invoked for its side effect.
}
\description{
The specified text is printed and written to the current log file. Does not 
overwrite the file. Also used internally by many functions in the package.
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}
file_name <- "log.txt"
init_log(file_name)
log_text("Hello World!")
# Print the contents of the file
scan(file_name, sep = "\n", what = "character")
\dontshow{setwd(.old_wd)}

}
\seealso{
\code{\link{init_log}}, \code{\link{finish_log}}
}
