% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_visualizations.R
\name{save_dc_plots}
\alias{save_dc_plots}
\title{Save drift correction plots}
\usage{
save_dc_plots(
  orig,
  dc,
  file,
  save = TRUE,
  log_transform = TRUE,
  width = 16,
  height = 8,
  color = "QC",
  shape = color,
  color_scale = getOption("notame.color_scale_dis"),
  shape_scale = scale_shape_manual(values = c(15, 16)),
  assay.orig = NULL,
  assay.dc = NULL
)
}
\arguments{
\item{orig}{a SummarizedExperiment object with assay before drift correction}

\item{dc}{a SummarizedExperiment object with assay after drift correction}

\item{file}{path to the PDF file where the plots should be saved}

\item{save}{logical, if false, the plots are not saved but returned as a list}

\item{log_transform}{logical, was the drift correction done on log-
transformed data?}

\item{width, height}{width and height of the plots in inches}

\item{color}{character, name of the column used for coloring the points}

\item{shape}{character, name of the column used for shape}

\item{color_scale}{the color scale as returned by a ggplot function}

\item{shape_scale}{the shape scale as returned by a ggplot function}

\item{assay.orig}{character, name of assay with abundances before correction}

\item{assay.dc}{character, name of assay after correction}
}
\value{
None, the function is invoked for its plot-saving side effect.
}
\description{
Plots the data before and after drift correction, with the regression line 
drawn with the original data. If the drift correction was done on 
log-transformed data, then plots of both the original and log-transformed 
data before and after correction are drawn.
The plot shows 2 standard deviation spread for both QC samples and regular 
samples.
}
\details{
By default, the column used for color is also used for shape.
}
\examples{
data(toy_notame_set, package = "notame")
\dontshow{.old_wd <- setwd(tempdir())}
toy_notame_set <- notame::mark_nas(toy_notame_set, value = 0)
dc <- notame::correct_drift(toy_notame_set, assay.type = 1,
                            name = "corrected")
save_dc_plots(toy_notame_set[1, ], dc[1, ], 
  file = "drift_plots.pdf",
  assay.orig = 1, assay.dc = "corrected")
\dontshow{setwd(.old_wd)}
}
\seealso{
\code{\link{correct_drift}}
}
