% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_visualizations.R
\name{plot_quality}
\alias{plot_quality}
\title{Plot quality metrics}
\usage{
plot_quality(
  object,
  all_features = FALSE,
  plot_flags = TRUE,
  assay.type = NULL
)
}
\arguments{
\item{object}{a \code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object}

\item{all_features}{logical, should all features be used? If FALSE (the 
default), flagged features are removed before visualization.}

\item{plot_flags}{logical, should the distribution of flags be added as a 
barplot?}

\item{assay.type}{character, assay to be used in case of multiple assays and 
no quality metrics are present in feature data}
}
\value{
A ggplot object.
}
\description{
Plots distribution of each quality metric, and a distribution of the flags.
}
\examples{
data(toy_notame_set, package = "notame")
plot_quality(toy_notame_set)

}
