% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_visualizations.R
\name{plot_injection_lm}
\alias{plot_injection_lm}
\title{Estimate the magnitude of drift}
\usage{
plot_injection_lm(object, all_features = FALSE, assay.type = NULL)
}
\arguments{
\item{object}{a \code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object}

\item{all_features}{logical, should all features be used? 
If FALSE (the default), flagged features are removed before visualization.}

\item{assay.type}{character, assay to be used in case of multiple assays}
}
\value{
A ggplot object.
}
\description{
Plots histograms of p-values from linear regression model, where each 
feature is predicted
by injection order alone. The expected uniform distribution is represented 
by a dashed red line.
}
\examples{
data(toy_notame_set, package = "notame")
plot_injection_lm(toy_notame_set)

}
\seealso{
\code{\link{plot_p_histogram}}
}
