% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effect_plots.R
\name{save_group_lineplots}
\alias{save_group_lineplots}
\title{Save line plots with errorbars by group}
\usage{
save_group_lineplots(
  object,
  all_features = FALSE,
  save = TRUE,
  file_path = NULL,
  format = "emf",
  x,
  group,
  title = "Feature_ID",
  subtitle = NULL,
  fun.data = "mean_cl_boot",
  fun = NULL,
  fun.min = NULL,
  fun.max = NULL,
  position_dodge_amount = 0.2,
  color_scale = getOption("notame.color_scale_dis"),
  text_base_size = 14,
  line_width = 0.5,
  point_size = 4,
  title_line_length = 40,
  theme = theme_bw(base_size = text_base_size),
  assay.type = NULL,
  ...
)
}
\arguments{
\item{object}{a \code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object}

\item{all_features}{logical, should all features be used? 
If FALSE (the default), flagged features are removed before visualization}

\item{save}{logical, if false, the plots are not saved but returned as a list}

\item{file_path}{character, a file path for PDF or prefix added to the file 
paths for other formats}

\item{format}{character, format in which the plots should be saved}

\item{x}{character, name of the column to be used as x-axis}

\item{group}{character, name of the column containing group information, 
used for coloring}

\item{title, subtitle}{column names from feature data to use as plot 
title/filename and subtitle.
Set to NULL for no title/subtitle, this creates running numbered filenames}

\item{fun.data}{passed to \code{\link[ggplot2]{stat_summary}} and used for 
errorbars, "A function that is given the complete data and should return a 
data frame with variables ymin, y, and ymax."}

\item{fun.min, fun, fun.max}{Alternative to fun.data, passed to 
\code{\link[ggplot2]{stat_summary}}, "supply three individual functions that 
are each passed a vector of x's and should return a single number"}

\item{position_dodge_amount}{numeric: how much the group mean points should 
dodge away from each other}

\item{color_scale}{the color scale as returned by a ggplot function}

\item{text_base_size}{integer, base size for text in figures}

\item{line_width}{numeric, width of the lines}

\item{point_size}{numeric, size of the points}

\item{title_line_length}{integer, maximum length of the title line in 
characters, passed to \code{\link[stringr]{str_wrap}}}

\item{theme}{a ggplot theme to be added to the plot}

\item{assay.type}{character, assay to be used in case of multiple assays}

\item{...}{other arguments to graphic device functions, like width and height}
}
\value{
By default, the function is invoked for its plot-saving side effect. 
The function returns a list of plots when \code{save = FALSE}.
}
\description{
Plots the change in the feature abundances as a function of e.g. time.
A line is drawn for each group and error bars are added.
A separate plot is drawn for each feature.
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}
data(toy_notame_set, package = "notame")
save_group_lineplots(notame::drop_qcs(toy_notame_set)[1:10],
  file_path = "./group_line_plots.pdf",
  format = "pdf", x = "Time", group = "Group"
)
save_group_lineplots(notame::drop_qcs(toy_notame_set)[1:10],
  file_path = "./group_line_plots/",
  format = "png", x = "Time", group = "Group"
)
# Plot one feature
save_group_lineplots(notame::drop_qcs(toy_notame_set[1, ]), save = FALSE,
x = "Time", group = "Group")
\dontshow{setwd(.old_wd)}

}
\seealso{
\code{\link{save_plot}},
\code{\link[ggplot2]{stat_summary}}
}
