% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariate.R
\name{perform_permanova}
\alias{perform_permanova}
\title{PERMANOVA}
\usage{
perform_permanova(
  object,
  group,
  all_features = FALSE,
  transform = "Standardize columns",
  coef = "Pythagorean",
  assay.type = NULL,
  ...
)
}
\arguments{
\item{object}{a \code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object}

\item{group}{character, name of the column to compare}

\item{all_features}{should all features be included?}

\item{transform}{Transformation to use in 
\code{\link[PERMANOVA]{IniTransform}}. By default uses "Standardize columns".}

\item{coef}{Coefficient to calculate continuous distances in 
\code{\link[PERMANOVA]{IniTransform}}.
By default uses Pythagorean distances.}

\item{assay.type}{character, assay to be used in case of multiple assays}

\item{...}{other parameters to \code{\link[PERMANOVA]{PERMANOVA}}}
}
\value{
A PERMANOVA object.
}
\description{
Performs permutational multivariate analysis of variance. Uses package 
called PERMANOVA.
}
\examples{
data(toy_notame_set, package = "notame")
permanova_res <- perform_permanova(
  notame::drop_qcs(toy_notame_set), 
  group = "Group")

}
