% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGcContent.R
\docType{methods}
\name{plotGcContent}
\alias{plotGcContent}
\alias{plotGcContent,ANY-method}
\alias{plotGcContent,FastqcData-method}
\alias{plotGcContent,FastqcDataList-method}
\alias{plotGcContent,FastpData-method}
\alias{plotGcContent,FastpDataList-method}
\title{Plot the Per Sequence GC Content}
\usage{
plotGcContent(x, usePlotly = FALSE, labels, pattern = ".(fast|fq|bam).*", ...)

\S4method{plotGcContent}{ANY}(x, usePlotly = FALSE, labels, pattern = ".(fast|fq|bam).*", ...)

\S4method{plotGcContent}{FastqcData}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  theoreticalGC = TRUE,
  gcType = c("Genome", "Transcriptome"),
  species = "Hsapiens",
  GCobject,
  plotlyLegend = FALSE,
  Fastafile,
  n = 1e+06,
  counts = FALSE,
  scaleColour = NULL,
  lineCols = c("red3", "black"),
  linetype = 1,
  linewidth = 0.5,
  ...
)

\S4method{plotGcContent}{FastqcDataList}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  theoreticalGC = TRUE,
  gcType = c("Genome", "Transcriptome"),
  species = "Hsapiens",
  GCobject,
  Fastafile,
  n = 1e+06,
  plotType = c("heatmap", "line", "cdf"),
  cluster = FALSE,
  dendrogram = FALSE,
  heat_w = 8,
  pwfCols,
  showPwf = TRUE,
  scaleFill = NULL,
  scaleColour = NULL,
  plotlyLegend = FALSE,
  lineCols = RColorBrewer::brewer.pal(12, "Paired"),
  linetype = 1,
  linewidth = 0.5,
  ...
)

\S4method{plotGcContent}{FastpData}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  theoreticalGC = TRUE,
  gcType = c("Genome", "Transcriptome"),
  species = "Hsapiens",
  GCobject,
  Fastafile,
  n = 1e+06,
  plotType = "bar",
  scaleFill = NULL,
  plotlyLegend = FALSE,
  plotTheme = theme_get(),
  ...
)

\S4method{plotGcContent}{FastpDataList}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  theoreticalGC = TRUE,
  gcType = c("Genome", "Transcriptome"),
  species = "Hsapiens",
  GCobject,
  Fastafile,
  n = 1e+06,
  plotType = "bar",
  scaleFill = NULL,
  plotTheme = theme_get(),
  plotlyLegend = FALSE,
  ...
)
}
\arguments{
\item{x}{Can be a \code{FastqcData}, \code{FastqcDataList} or character
vector of file paths}

\item{usePlotly}{\code{logical} Default \code{FALSE} will render using
ggplot. If \code{TRUE} plot will be rendered with plotly}

\item{labels}{An optional named vector of labels for the file names.}

\item{pattern}{Pattern to remove from the end of filenames}

\item{...}{Used to pass various potting parameters to themes and geoms.}

\item{theoreticalGC}{\code{logical} default is \code{FALSE} to give the true
GC content, set to \code{TRUE} to normalize values of GC_Content by the
theoretical values using \code{\link[=gcTheoretical]{gcTheoretical()}}. \code{species} must be
specified. For Fastqc* objects, the entire distributions will be used,
wheras for the Fastp* objects, only the expected mean value is shown as a
horizontal line}

\item{gcType}{\code{character} Select type of data to normalize GC
content against. Accepts either "Genome" (default) or "Transcriptome".}

\item{species}{\code{character} if \code{gcTheory} is \code{TRUE} it must be
accompanied by a species. Species currently supported can be obtained using
\code{mData(gcTheoretical)}}

\item{GCobject}{an object of class GCTheoretical.
Defaults to the gcTheoretical object supplied with the package}

\item{plotlyLegend}{logical(1) Show legend on interactive line plots}

\item{Fastafile}{a fasta file contains DNA sequences to generate theoretical
GC content}

\item{n}{number of simulated reads to generate theoretical GC content from
\code{Fastafile}}

\item{counts}{\code{logical}. Plot the counts from each file if
\code{counts = TRUE}, otherwise frequencies will be plotted.
Ignored if calling the function on a FastqcDataList.}

\item{scaleColour}{ggplot2 scale for line colours}

\item{lineCols, linetype, linewidth}{Line colour type and width for observed
and theoretical GC lines}

\item{plotType}{Takes values "line", "heatmap" or "cdf"}

\item{cluster}{\code{logical} default \code{FALSE}. If set to \code{TRUE},
fastqc data will be clustered using hierarchical clustering}

\item{dendrogram}{\code{logical} redundant if \code{cluster} is \code{FALSE}
if both \code{cluster} and \code{dendrogram} are specified as \code{TRUE}
then the dendrogram  will be displayed.}

\item{heat_w}{Relative width of any heatmap plot components}

\item{pwfCols}{Object of class \code{\link[=PwfCols]{PwfCols()}} to give colours for
pass, warning, and fail values in plot}

\item{showPwf}{logical(1) Show Pwf Status on the plot}

\item{scaleFill}{ggplot2 scale for filling heatmap cells or bars}

\item{plotTheme}{\link[ggplot2]{theme} object}
}
\value{
A ggplot2 or plotly object
}
\description{
Plot the Per Sequence GC Content for a set of FASTQC files
}
\details{
Makes plots for GC_Content.
When applied to a single FastqcData object a simple line plot will be drawn,
with Theoretical GC content overlaid if desired.

When applied to multiple FastQC reports, the density at each GC content bin
can be shown as a heatmap by setting \code{theoreticalGC = FALSE}. By
default the difference in observed and expected theoretical GC is shown.
Species and genome/transcriptome should also be set if utilising the
theoretical GC content.

As an alternative to a heatmap, a series of overlaid distributions can be
shown by setting \code{plotType = "line"}.

Can produce a static ggplot2 object or an interactive plotly object.
}
\examples{

# Get the files included with the package
packageDir <- system.file("extdata", package = "ngsReports")
fl <- list.files(packageDir, pattern = "fastqc.zip", full.names = TRUE)

# Load the FASTQC data as a FastqcDataList object
fdl <- FastqcDataList(fl)

# The default plot for a FastqcDataList
plotGcContent(fdl)

# Plot a single FastqcData object
plotGcContent(fdl[[1]])

}
