% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFastqcPCA.R
\docType{methods}
\name{plotFastqcPCA}
\alias{plotFastqcPCA}
\alias{plotFastqcPCA,ANY-method}
\alias{plotFastqcPCA,character-method}
\alias{plotFastqcPCA,FastqcDataList-method}
\title{Draw a PCA plot for Fast QC modules}
\usage{
plotFastqcPCA(
  x,
  module = "Per_sequence_GC_content",
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  sz = 4,
  groups,
  ...
)

\S4method{plotFastqcPCA}{ANY}(
  x,
  module = "Per_sequence_GC_content",
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  sz = 4,
  groups,
  ...
)

\S4method{plotFastqcPCA}{character}(
  x,
  module = "Per_sequence_GC_content",
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  sz = 4,
  groups,
  ...
)

\S4method{plotFastqcPCA}{FastqcDataList}(
  x,
  module = "Per_sequence_GC_content",
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  sz = 4,
  groups,
  pc = c(1, 2),
  ...
)
}
\arguments{
\item{x}{Can be a \code{FastqcDataList} or \code{character} vector of file paths}

\item{module}{\code{character} vector containing
the desired FastQC module (eg. c("Per_base_sequence_quality",
"Per_base_sequence_content"))}

\item{usePlotly}{\code{logical}. Output as ggplot2 (default) or plotly
object.}

\item{labels}{An optional named vector of labels for the file names.
All file names must be present in the names of the vector.}

\item{pattern}{Regex to remove from the end of any filenames}

\item{sz}{The size of the text labels}

\item{groups}{Optional factor of the same length as x. If provided,
the plot will be coloured using this factor as the defined groups.
Ellipses will also be added to the final plot.}

\item{...}{Used to pass additional attributes to theme() and between methods}

\item{pc}{The two components to be plotted}
}
\value{
A standard ggplot2 object, or an interactive plotly object
}
\description{
Draw a PCA plot for Fast QC modules across multiple samples
\lifecycle{experimental}
}
\details{
This carries out PCA on a single FastQC module and plots the
output using either ggplot or plotly. Current modules for PCA are
Per_base_sequence_quality, Per_sequence_quality_scores,
Per_sequence_GC_content, Per_base_sequence_content, and
Sequence_Length_Distribution.

If a factor is provided in the groups argument, this will be applied to the
plotting colours and ellipses will be drawn using these groups.
Only the labels will be plotted using \code{geom_text()}
}
\examples{

# Get the files included with the package
packageDir <- system.file("extdata", package = "ngsReports")
fl <- list.files(packageDir, pattern = "fastqc.zip", full.names = TRUE)

# Load the FASTQC data as a FastqcDataList object
fdl <- FastqcDataList(fl)
grp <- as.factor(gsub(".+(R[12]).*", "\\\\1", fqName(fdl)))
plotFastqcPCA(fdl, module = "Per_sequence_GC_content", groups = grp)


}
