% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAlignmentSummary.R
\name{plotAlignmentSummary}
\alias{plotAlignmentSummary}
\title{Plot a summary of alignments}
\usage{
plotAlignmentSummary(
  x,
  type = c("star", "bowtie", "bowtie2", "hisat2"),
  usePlotly = FALSE,
  stripPaths = TRUE,
  asPercent = FALSE,
  ...,
  fill = c("red", "yellow", "blue", rgb(0, 0.5, 1))
)
}
\arguments{
\item{x}{Paths to one or more alignment log files}

\item{type}{The aligner used. Can be one of star, bowtie, bowtie2 or hisat2}

\item{usePlotly}{logical. If TRUE an interactive plot will be generated.}

\item{stripPaths}{logical(1). Remove paths from the Filename column}

\item{asPercent}{Show alignments as percentages, with the alternative (FALSE)
being the total number of reads
If FALSE a ggplot object will be output}

\item{...}{Used to pass additional attributes to theme() and between methods}

\item{fill}{Colours used to fill the bars. Passed to scale_fill_manual.}
}
\value{
A ggplot2 object, or a plotly object
}
\description{
Plot a summary of alignments from a set of log files
}
\details{
Loads a set of alignment log files and creates a default plot.
Implemented aligners are \code{bowtie}, \code{bowtie2}, \code{Hisat2} and
\code{STAR}.
}
\examples{

f <- c("bowtie2PE.txt", "bowtie2SE.txt")
bowtie2Logs <- system.file("extdata", f, package = "ngsReports")
plotAlignmentSummary(bowtie2Logs, "bowtie2")

}
