% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxAdapterContent.R
\name{maxAdapterContent}
\alias{maxAdapterContent}
\title{Get the maximum Adapter Content}
\usage{
maxAdapterContent(x, asPercent = TRUE)
}
\arguments{
\item{x}{Can be a \code{.FastqcFile}, \code{FastqcData},
\code{FastqcDataList} or path}

\item{asPercent}{\code{logical}.
Format the values as percentages with the added \verb{\\\%} symbol}
}
\value{
A \code{tibble} object containing the percent of reads with each
adapter type at the final position
}
\description{
Get the maximum Adapter Content across one or more FASTQC
reports
}
\details{
This will extract the \code{Adapter_Content} module from the
supplied object, and provide a \code{tibble} with the final value for each
file.
}
\examples{
# Get the files included with the package
packageDir <- system.file("extdata", package = "ngsReports")
fl <- list.files(packageDir, pattern = "fastqc.zip", full.names = TRUE)

# Load the FASTQC data as a FastqcDataList object
fdl <- FastqcDataList(fl)

# Get the maxAdapterContent
maxAdapterContent(fdl)

}
