% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importNgsLogs.R
\name{importNgsLogs}
\alias{importNgsLogs}
\title{Import Various NGS-related log files}
\usage{
importNgsLogs(x, type = "auto", which, stripPaths = TRUE)
}
\arguments{
\item{x}{\code{character}. Vector of filenames. All log files must be of the
same type. Duplicate file paths will be silently ignored.}

\item{type}{\code{character}. The type of file being imported. Can be one of
\code{bowtie}, \code{bowtie2}, \code{hisat2}, \code{star}, \code{flagstat},
\code{featureCounts}, \code{duplicationMetrics}, \code{cutadapt}, \code{umitoolsDedup},
\code{macs2Callpeak}, \code{adapterRemoval}, \code{rnaseqcMetrics}, \code{quast},
\code{salmonLibFormatCounts}, \code{salmonMetaInfo} or \code{busco}.
Defaults to \code{type = "auto"} which will automatically detect the file
type for all implemented types.}

\item{which}{Which element of the parsed object to return. Ignored in all
file types except when \code{type} is set to duplicationMetrics, cutadapt or
adapterRemoval. See details for possible values.
To return all elements, set this value to 'all'}

\item{stripPaths}{logical(1). Remove paths from the Filename column}
}
\value{
A \code{tibble}.
Column names are broadly similar to the text in supplied files,
but have been modified for easier handling under R naming conventions.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}
Imports NGS-related log files such as those generated from
stderr.
}
\details{
Imports one or more log files as output by tools such as:
\code{bowtie}, \code{bowtie2}, \code{featureCounts}, \code{Hisat2}, \code{STAR}, \code{salmon}
\verb{picard MarkDuplicates}, \code{cutadapt}, \code{flagstat}, \code{macs2Callpeak},
\verb{Adapter Removal}, \code{trimmomatic}, \code{rnaseqcMetrics}, \code{quast} or \code{busco}.
\code{autoDetect} can be used to detect the log type by parsing the file.

The featureCounts log file corresponds to the \code{counts.out.summary},
not the main \code{counts.out} file.

Whilst most log files return a single tibble, some are more complex
with multiple modules.

\code{adapterRemoval} can return one of four modules (which = 1:4),.
When calling by name, the possible values are sequences, settings,
statistics or distribution.
Partial matching is implemented.

\code{cutadapt} can return one of five modules (which = 1:5).
When calling by name the possible modules are summary, adapter1, adapter2,
adapter3 or overview.
Note that adapter2/3 may be missing from these files depending on the nature
of your data.
If cutadapt log files are obtained using \code{report=minimal}, all supplied
log files must be of this format and no modules can be returned.

\code{duplicationMetrics} will return either the metrics of histogram.
These can be requested by setting which as 1 or 2, or naming either module.
}
\examples{
f <- c("bowtiePE.txt", "bowtieSE.txt")
bowtieLogs <- system.file("extdata", f, package = "ngsReports")
df <- importNgsLogs(bowtieLogs, type = "bowtie")

}
