% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fqName.R
\name{fqName}
\alias{fqName}
\alias{fqName,ANY-method}
\alias{fqName,FastqcData-method}
\alias{fqName,FastqcDataList-method}
\alias{fqName<-}
\alias{fqName<-,FastqcData-method}
\alias{fqName<-,FastqcDataList-method}
\alias{fqName,FastpData-method}
\alias{fqName,FastpDataList-method}
\title{Return the Underlying Fastq File Names from Fastqc/Fastp Objects}
\usage{
fqName(object)

\S4method{fqName}{ANY}(object)

\S4method{fqName}{FastqcData}(object)

\S4method{fqName}{FastqcDataList}(object)

fqName(object) <- value

\S4method{fqName}{FastqcData}(object) <- value

\S4method{fqName}{FastqcDataList}(object) <- value

\S4method{fqName}{FastpData}(object)

\S4method{fqName}{FastpDataList}(object)
}
\arguments{
\item{object}{An object able to extract an Fastq name from}

\item{value}{Replacement value for fqName}
}
\value{
Returns the names of the Fastq files the FastQC report was
generated from, without any preceding directories.
}
\description{
Return the Underlying Fastq File Names from Fastqc/Fastp Objects
}
\examples{

# Get the files included with the package
packageDir <- system.file("extdata", package = "ngsReports")
fl <- list.files(packageDir, pattern = "fastqc.zip", full.names = TRUE)

# Load the FASTQC data as a FastqcDataList object
fdl <- FastqcDataList(fl)
fqName(fdl)

nm <- paste0(letters[seq_along(fdl)], ".fq")
fqName(fdl) <- nm
fqName(fdl)


}
