% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netprioR-functions.R
\name{learn}
\alias{learn}
\title{Fit netprioR model}
\usage{
learn(Yobs, X, G, l, u, a = 0.1, b = 0.1, sigma2 = 1, tau2 = 10,
  eps = 1e-11, max.iter = 500, thresh = 0.001, use.cg = TRUE,
  thresh.cg = 1e-05, nrestarts = 5, max.cores = detectCores(),
  verbose = FALSE)
}
\arguments{
\item{Yobs}{Observed labels (NA, if not observed)}

\item{X}{Phenotypes}

\item{G}{Graph Laplacians}

\item{l}{Indices of labelled instances}

\item{u}{Indices of unlabelled instances}

\item{a}{Shape parameter of Gamma prior for W}

\item{b}{Scale parameter of Gamma prior for W}

\item{sigma2}{Cariance for Gaussian labels}

\item{tau2}{Variance for Gaussian prior for beta}

\item{eps}{Small value added to diagonal of Q in order to make it non-singular}

\item{max.iter}{Maximum number of iterations for EM}

\item{thresh}{Threshold for termination of EM with respect to change in parameters}

\item{use.cg}{Flag whether to use conjugate gradient instead of exact computation of expectations}

\item{thresh.cg}{Threshold for the termination of the conjugate gradient solver}

\item{nrestarts}{Number of restarts for EM}

\item{max.cores}{Maximum number of cores to use for parallel computation}

\item{verbose}{Print verbose output}
}
\value{
List containing: Predicted labels Yhat and inferred parameters W and beta
}
\description{
Infer parameters and hidden data using the EM algorithm of netprioR
}
\author{
Fabian Schmich
}

