% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvglasso.R
\name{het_cv_glasso}
\alias{het_cv_glasso}
\title{Cross-validated glasso on heterogeneous dataset with grouping}
\usage{
het_cv_glasso(data, grouping = rep(1, dim(data)[1]), mc.flag = FALSE,
  use.package = "huge", normalise = FALSE, verbose = FALSE, ...)
}
\arguments{
\item{data}{The heterogenous network data. Needs to be 
a num.samples by dim.samples matrix or dataframe.}

\item{grouping}{The grouping of samples; a vector of length num.samples,
with num.groups unique elements.}

\item{mc.flag}{Whether to use parallel processing via package mclapply to
distribute the glasso estimation over different groups.}

\item{use.package}{'glasso' for glasso package, or 'huge' for huge package 
(default)}

\item{normalise}{If TRUE, normalise the columns of the data matrix before 
running glasso.}

\item{verbose}{If TRUE, output progress.}

\item{...}{Further parameters to be passed to \code{screen_cv.glasso}.}
}
\value{
Returns a list with named elements 'Sig', 'SigInv', 'Mu', 'Sigma.diag', 
'group.names' and 'var.names. 
The variables Sig and SigInv are arrays of size dim.samples by dim.samples 
by num.groups, where the first two dimensions contain the (inverse)
covariance matrix for the network obtained by running glasso on group k. Variables 
Mu and Sigma.diag contain the mean and variance of the input data,
and group.names and var.names contains the names for the groups and
variables in the data (if specified as colnames of the input data matrix).
}
\description{
Run glasso on a heterogeneous dataset to obtain networks (inverse covariance 
matrices) of the variables in the dataset for each pre-specified group of 
samples.
}
\details{
This function runs the graphical lasso with 
cross-validation to determine the best parameter lambda for each group of 
samples. Note that this function defaults to using package huge (rather than
package glasso) unless otherwise specified, as it tends to be more 
numerically stable.
}
\examples{
n = 100
p = 25

# Generate networks with random means and covariances. 
sim.result = sim_mix_networks(n, p, n.comp=3)

test.data = sim.result$data
test.labels = sim.result$comp

# Reconstruct networks for each component
networks = het_cv_glasso(data=test.data, grouping=test.labels) 
}
