% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netsim.R
\name{generate_2networks}
\alias{generate_2networks}
\title{Generate sparse invcov with overlap}
\usage{
generate_2networks(p, graph = "random", n.nz = rep(p, 2),
  n.nz.common = p, n.hub = 2, n.hub.diff = 1, magn.nz.diff = 0.8,
  magn.nz.common = 0.9, magn.diag = 0, emin = 0.1, verbose = FALSE)
}
\arguments{
\item{p}{number of nodes}

\item{graph}{'random' or 'hub'}

\item{n.nz}{number of edges per graph (only for graph='random')}

\item{n.nz.common}{number of edges incommon between graphs (only for 
graph='random')}

\item{n.hub}{number of hubs (only for graph='hub')}

\item{n.hub.diff}{number of different hubs}

\item{magn.nz.diff}{default=0.9}

\item{magn.nz.common}{default=0.9}

\item{magn.diag}{default=0}

\item{emin}{default=0.1 (see ?huge.generator)}

\item{verbose}{If verbose=FALSE then tracing output is disabled.}
}
\value{
Two sparse inverse covariance matrices with overlap
}
\description{
Generate two sparse inverse covariance matrices with overlap
}
\examples{
n <- 70
p <- 30

## Specifiy sparse inverse covariance matrices,
## with number of edges in common equal to ~ 0.8*p
gen.net <- generate_2networks(p,graph='random',n.nz=rep(p,2),
                              n.nz.common=ceiling(p*0.8))

invcov1 <- gen.net[[1]]
invcov2 <- gen.net[[2]]

plot_2networks(invcov1,invcov2,label.pos=0,label.cex=0.7)
}
