% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netboost.R
\name{calculate_adjacency}
\alias{calculate_adjacency}
\title{Calculate network adjacencies for filter}
\usage{
calculate_adjacency(
  datan,
  filter,
  soft_power = 2,
  method = c("pearson", "kendall", "spearman"),
  cores = getOption("mc.cores", 2L)
)
}
\arguments{
\item{datan}{Data frame were rows correspond to samples and columns to
features.}

\item{filter}{Filter-Matrix as generated by the nb_filter function.}

\item{soft_power}{Integer. Exponent of the transformation. Set automatically
based on the scale free topology criterion if unspecified.}

\item{method}{A character string specifying the method to be used for
correlation coefficients.}

\item{cores}{Integer. Amount of CPU cores used (<=1 : sequential).}
}
\value{
Vector with adjacencies for the filter
}
\description{
Calculate network adjacencies for filter
}
