% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndex_networks_ndex_properties.r
\name{ndex_network_update_profile}
\alias{ndex_network_update_profile}
\title{Update Network Profile}
\usage{
ndex_network_update_profile(
  ndexcon,
  networkId,
  name = NULL,
  description = NULL,
  version = NULL
)
}
\arguments{
\item{ndexcon}{object of class NDExConnection link{ndex_connect}}

\item{networkId}{unique ID of the network}

\item{name}{character (optional); Changes the name the network. At least one of name, description or version have to be set!}

\item{description}{character (optional); Changes the description the network. At least one of name, description or version have to be set!}

\item{version}{character (optional); Changes the version the network. At least one of name, description or version have to be set!}
}
\value{
NULL on success; Error else
}
\description{
Updates the profile information of the network. Any profile attributes specified will be updated but attributes that are not specified will have no effect - omission of an attribute does not mean deletion of that attribute.
}
\note{
Requires an authorized user! (ndex_connect with credentials)

Compatible to NDEx server version 1.3 and 2.0
}
\section{REST query}{

GET: ndex_config$api$network$profile$update
}

\examples{
## Establish a server connection with credentials 
# ndexcon = ndex_connect('MyAccountName', 'MyPassword')
## Find one of your networks and get its UUID
# networks = ndex_find_networks(ndexcon, accountName='MyAccountName')
# networkId = networks[1,"externalId"]
## Update network profile
# ndex_network_update_profile(ndexcon, networkId, name="Some fancy name for the network")
# ndex_network_update_profile(ndexcon, networkId, description="Description of the network")
# ndex_network_update_profile(ndexcon, networkId, version="1.2.3.4")
# ndex_network_update_profile(ndexcon, networkId, name="Special test network", 
#                             description="Nothing to see here", version="1.3")
NULL
}
