% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndex_networks_aspects_and_metadata.r
\name{ndex_network_update_aspect}
\alias{ndex_network_update_aspect}
\title{Update an Aspect of a Network}
\usage{
ndex_network_update_aspect(
  ndexcon,
  networkId,
  aspectName,
  aspectAsRCX,
  isJson = FALSE
)
}
\arguments{
\item{ndexcon}{object of class NDExConnection link{ndex_connect}}

\item{networkId}{unique ID of the network}

\item{aspectName}{name of the aspect}

\item{aspectAsRCX}{rcx data for the aspect (rcx[[aspectName]])}

\item{isJson}{logical if aspectAsRCX is already JSON}
}
\value{
networkId unique ID of the modified network
}
\description{
This function updates an aspect with the provided CX for the aspect.
}
\note{
Requires an authorized user! (ndex_connect with credentials)

Compatible to NDEx server version 2.0
}
\section{REST query}{

PUT: ndex_config$api$network$aspect$update
}

\examples{
## Establish a server connection with credentials 
# ndexcon = ndex_connect('MyAccountName', 'MyPassword')
## Find one of your networks and get its UUID
# networks = ndex_find_networks(ndexcon, accountName='MyAccountName')
# networkId = networks[1,"externalId"]
## Get the network data 
# aspect = ndex_network_get_aspect(ndexcon, networkId, 'nodeAttributes') 
## Do some changes to the aspect..
# aspectModified = aspect[1:5,]
## and update the aspect
# ndex_network_update_aspect(ndexcon,pws[1,"externalId"], 'nodeAttributes', aspectModified)
NULL
}
