% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndex_groups.R
\name{ndex_group_list_networks}
\alias{ndex_group_list_networks}
\title{Get Network Permissions of a Group}
\usage{
ndex_group_list_networks(
  ndexcon,
  groupId,
  permission = NULL,
  start = NULL,
  size = NULL
)
}
\arguments{
\item{ndexcon}{object of class NDExConnection link{ndex_connect}}

\item{groupId}{character; unique ID (UUID) of the group}

\item{permission}{character (optional) ("WRITE"|"READ) (default: "READ"); constrains the type of the returned permission.}

\item{start}{integer (optional); specifies that the result is the nth page of the requested data.}

\item{size}{integer (optional); specifies the number of data items in each page.}
}
\value{
List of network permissions of that group or empty object
}
\description{
Get Network Permissions of a Group
}
\note{
Compatible to NDEx server version 2.0
}
\section{REST query}{

GET: ndex_config$api$group$network$list
}

\examples{
## Establish a server connection
ndexcon = ndex_connect()
## Find a group
groups = ndex_find_groups(ndexcon,"Ideker Lab")
groupId = groups[1,"externalId"]
## List networks of the group
networks = ndex_group_list_networks(ndexcon, groupId)
networks = ndex_group_list_networks(ndexcon, groupId, permission='READ', start=0, size=10)
}
