% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncdfIO.R
\name{read.ncdfFlowSet}
\alias{read.ncdfFlowSet}
\alias{read.ncdfFlowset}
\title{create ncdfFlowSet from FCS files}
\usage{
read.ncdfFlowSet(
  files = NULL,
  ncdfFile,
  flowSetId = flowCore:::guid(),
  isWriteSlice = TRUE,
  phenoData,
  channels = NULL,
  channel_alias = NULL,
  alter.names = FALSE,
  dim = 2,
  compress = 0,
  mc.cores = NULL,
  ...
)
}
\arguments{
\item{files}{A character vector giving the source FCS raw file paths.}

\item{ncdfFile}{A character scalar giving the output file name. Default is NULL and the function will generate a random
file in the temporary folder, potentially adding the \code{.cdf} suffix unless a file
extension is already present. It is sometimes useful to specify this file path to avoid the failure of writing large flow data set to cdf file 
due to the the shortage of disk space in system temporary folder. 
It is only valid when isNewNcFile=TRUE}

\item{flowSetId}{A character scalar giving the unique ncdfFlowSet ID.}

\item{isWriteSlice}{A logical scalar indicating whether the raw data should also be copied.if FALSE,
an empty cdf file is created with the dimensions (sample*events*channels) supplied by raw FCS files.}

\item{phenoData}{An object of \code{AnnotatedDataFrame} providing a way to manually set the phenotyoic data for the whole data set in ncdfFlowSet.}

\item{channels}{A character vector specifying which channels to extract from FCS files.
It can be useful when FCS files do not share exactly the same channel names.
Thus this argument is used to select those common channels that are of interests.
Default value is NULL and the function will try to scan the FCS headers of all files
and determine the common channels.}

\item{channel_alias, alter.names}{see \link{read.FCS}}

\item{dim}{\code{integer} the number of dimensions that specifies the physical storage format of hdf5 dataset.
Default is 2, which stores each FCS data as a seperate 2d dataset. 
Normally, user shouldn't need to change this but dim can also be set to 3, which stores all FCS data as one single 3d dataset.}

\item{compress}{\code{integer} the HDF5 compression ratio (from 0 to 9). Default is 0, which does not compress the data and is recommeneded (especially for 2d format) because the speed loss usually outweights the disk saving.}

\item{mc.cores}{\code{numeric} passed to parallel::mclapply. Default is NULL, which read FCS files in serial mode.}

\item{...}{extra arguments to be passed to \code{\link{read.FCS}}.}
}
\value{
A ncdfFlowSet object
}
\description{
read FCS files from the disk and load them into a ncdfFlowSet object
}
\examples{
library(ncdfFlow)

path<-system.file("extdata","compdata","data",package="flowCore")
files<-list.files(path,full.names=TRUE)[1:3]

#create ncdfFlowSet from fcs with the actual raw data written in cdf
nc1  <- read.ncdfFlowSet(files=files,ncdfFile="ncfsTest.nc",flowSetId="fs1",isWriteSlice= TRUE)
nc1
nc1[[1]]
unlink(nc1)
rm(nc1)

#create empty ncdfFlowSet from fcs and add data slices afterwards
nc1  <- read.ncdfFlowSet(files=files,ncdfFile="ncfsTest.nc",flowSetId="fs1",isWriteSlice= FALSE)
fs1<-read.flowSet(files)
nc1[[1]] <- fs1[[1]]
nc1[[1]]
nc1[[2]]
}
\seealso{
\code{\link{clone.ncdfFlowSet}}
}
