% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncGTWalign.R
\name{ncGTWalign}
\alias{ncGTWalign}
\title{Run ncGTW alignment}
\usage{
ncGTWalign(ncGTWinput, xcmsLargeWin, parSamp = 10, k1Num = 3,
  k2Num = 1, bpParam = BiocParallel::SnowParam(workers = 1),
  ncGTWparam = NULL)
}
\arguments{
\item{ncGTWinput}{A \code{\link{ncGTWinput}} object.}

\item{xcmsLargeWin}{A \code{\link[xcms]{xcmsSet-class}} object.}

\item{parSamp}{Decide how many samples are in each group when considering
parallel computing, and the default is 10.}

\item{k1Num}{Decide how many different k1 will be tested in stage 1. The
default is 3.}

\item{k2Num}{Decide how many different k2 will be tested in stage 2. The
default is 1.}

\item{bpParam}{A object of \pkg{BiocParallel} to control parallel processing,
and can be created by
\code{\link[BiocParallel:SerialParam-class]{SerialParam}},
\code{\link[BiocParallel:MulticoreParam-class]{MulticoreParam}}, or
\code{\link[BiocParallel:SnowParam-class]{SnowParam}}.}

\item{ncGTWparam}{A \code{\link{ncGTWparam}} object.}
}
\value{
A \code{\link{ncGTWoutput}} object.
}
\description{
This function applies ncGTW alignment to the input feature.
}
\details{
This function realign the input feature with ncGTW alignment
function with given m/z and RT range.
}
\examples{
# obtain data
data('xcmsExamples')
xcmsLargeWin <- xcmsExamples$xcmsLargeWin
xcmsSmallWin <- xcmsExamples$xcmsSmallWin
ppm <- xcmsExamples$ppm

# detect misaligned features
excluGroups <- misalignDetect(xcmsLargeWin, xcmsSmallWin, ppm)

# obtain the paths of the sample files
filepath <- system.file("extdata", package = "ncGTW")
file <- list.files(filepath, pattern="mzxml", full.names=TRUE)

tempInd <- matrix(0, length(file), 1)
for (n in seq_along(file)){
    tempCha <- file[n]
    tempLen <- nchar(tempCha)
    tempInd[n] <- as.numeric(substr(tempCha, regexpr("example", tempCha) + 7,
        tempLen - 6))
}
# sort the paths by data acquisition order
file <- file[sort.int(tempInd, index.return = TRUE)$ix]
\dontrun{
# load the sample profiles
ncGTWinputs <- loadProfile(file, excluGroups)

# initialize the parameters of ncGTW alignment with default
ncGTWparam <- new("ncGTWparam")

# run ncGTW alignment
ncGTWoutputs <- vector('list', length(ncGTWinputs))
for (n in seq_along(ncGTWinputs))
    ncGTWoutputs[[n]] <- ncGTWalign(ncGTWinputs[[n]], xcmsLargeWin, 5,
        ncGTWparam = ncGTWparam)
}
}
