% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mzIDpsm.R
\docType{class}
\name{mzIDpsm-class}
\alias{id,mzIDpsm-method}
\alias{idScanMap,mzIDpsm-method}
\alias{length,mzIDpsm-method}
\alias{mzIDpsm-class}
\alias{scans,mzIDpsm-method}
\alias{show,mzIDpsm-method}
\title{A class to store psm information from an mzIdentML file}
\usage{
\S4method{show}{mzIDpsm}(object)

\S4method{length}{mzIDpsm}(x)

\S4method{id}{mzIDpsm}(object, safeNames = TRUE)

\S4method{scans}{mzIDpsm}(object, safeNames = TRUE)

\S4method{idScanMap}{mzIDpsm}(object)
}
\arguments{
\item{object}{An mzIDpsm object}

\item{x}{An mzIDpsm object}

\item{safeNames}{Should column names be lowercased to ensure compatibility
between v1.0 and v1.1 files?}
}
\description{
This class handles parsing and storage of scan info and the related psm's. 
This information resides in the
/*/x:DataCollection/x:AnalysisData/x:SpectrumIdentificationList/x:SpectrumIdentificationResult
node.
}
\details{
The content of the class is stored as two data frames: One containing a row 
for each scan in the results, and one containing all psm's in the results. 
Additionally a list containing indexing from scan to psm is stored.
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: A short summary of the content

\item \code{length}: Get the number of psm'

\item \code{id}: Get the identification results

\item \code{scans}: Get the scans matched to peptides

\item \code{idScanMap}: Get the link between scans and identifications
}}
\section{Slots}{

\describe{
\item{\code{scans}}{A data.frame containing all reference to all scans with at least 
one psm. The columns gives at least an ID, a spectrumID and a reference to 
the file used.}

\item{\code{id}}{A data.frame containing all psm's from the analysis. The columns 
depend on the file but at least id, chargeState, experimentalMassToCharge, 
passThreshold and rank must exist according to the mzIdentML specifications.}

\item{\code{mapping}}{A list with an entry for each row in @scans. Each entry 
contains an integer vector pointing to the related rows in @id.}
}}
\section{Objects from the class}{

Objects of mzIDpsm are not meant to be created explicitly but as part of the 
\code{\link{mzID-class}}. Still object can be created with the constructor 
\code{\link{mzIDpsm}}.
}
\seealso{
\code{\link{mzIDpsm}}

Other mzID.classes: \code{\link{mzID-class}},
  \code{\link{mzIDCollection-class}},
  \code{\link{mzIDdatabase-class}},
  \code{\link{mzIDevidence-class}},
  \code{\link{mzIDparameters-class}},
  \code{\link{mzIDpeptides-class}}
}

